/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.guice;

import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.vyarus.dropwizard.guice.module.GuiceBootstrapModule;
import ru.vyarus.dropwizard.guice.module.yaml.bind.ConfigBindingModule;

public class GuiceConfig {
    private final List<String> ignorePackages = new ArrayList<String>();
    private final List<Class<? extends Module>> ignoreModules = new ArrayList<Class<? extends Module>>();

    public GuiceConfig hidePackages(String ... pkgs) {
        Collections.addAll(this.ignorePackages, pkgs);
        return this;
    }

    @SafeVarargs
    public final GuiceConfig hideModules(Class<? extends Module> ... modules) {
        Collections.addAll(this.ignoreModules, modules);
        return this;
    }

    public GuiceConfig hideGuiceBindings() {
        return this.hidePackages("com.google.inject");
    }

    public GuiceConfig hideGuiceyBindings() {
        return this.hideModules(GuiceBootstrapModule.class);
    }

    public GuiceConfig hideYamlBindings() {
        return this.hideModules(ConfigBindingModule.class);
    }

    public List<String> getIgnorePackages() {
        return this.ignorePackages;
    }

    public List<Class<? extends Module>> getIgnoreModules() {
        return this.ignoreModules;
    }
}

