/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.test.EnableHook;

public final class HooksUtil {
    private HooksUtil() {
    }

    public static void validateFieldHooks(List<Field> fields, boolean includeInstanceFields) {
        for (Field field : fields) {
            if (!GuiceyConfigurationHook.class.isAssignableFrom(field.getType())) {
                throw new IllegalStateException(String.format("Field %s annotated with @%s, but its type is not %s", HooksUtil.toString(field), EnableHook.class.getSimpleName(), GuiceyConfigurationHook.class.getSimpleName()));
            }
            if (includeInstanceFields || Modifier.isStatic(field.getModifiers())) continue;
            throw new IllegalStateException(String.format("Field %s annotated with @%s must be static", HooksUtil.toString(field), EnableHook.class.getSimpleName()));
        }
    }

    @SafeVarargs
    public static List<GuiceyConfigurationHook> create(Class<? extends GuiceyConfigurationHook> ... hooks) {
        ArrayList<GuiceyConfigurationHook> res = new ArrayList<GuiceyConfigurationHook>();
        for (Class<? extends GuiceyConfigurationHook> hook : hooks) {
            try {
                res.add(hook.newInstance());
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate guicey hook: " + hook.getSimpleName(), e);
            }
        }
        return res;
    }

    public static void register(List<GuiceyConfigurationHook> hooks) {
        if (hooks != null) {
            for (GuiceyConfigurationHook hook : hooks) {
                if (hook == null) continue;
                hook.register();
            }
        }
    }

    private static String toString(Field field) {
        return field.getDeclaringClass().getName() + "." + field.getName();
    }
}

