/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.jersey;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Injector;
import io.dropwizard.setup.Environment;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.Path;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.AbstractJerseyInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.TypeInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.BindingInstaller;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;
import ru.vyarus.dropwizard.guice.module.installer.util.BindingUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.JerseyBinding;

@Order(value=40)
public class ResourceInstaller
extends AbstractJerseyInstaller<Object>
implements BindingInstaller,
TypeInstaller<Object> {
    @Override
    public boolean matches(Class<?> type) {
        return !type.isInterface() && (FeatureUtils.hasAnnotation(type, Path.class) || this.hasMatchedInterfaces(type));
    }

    @Override
    public void bind(Binder binder, Class<?> type, boolean lazyMarker) {
        boolean jerseyManaged = this.isJerseyExtension(type);
        boolean lazy = this.isLazy(type, lazyMarker);
        if (!jerseyManaged && !lazy) {
            this.bindInGuice(binder, type);
        }
    }

    @Override
    public <T> void manualBinding(Binder binder, Class<T> type, Binding<T> binding) {
        boolean hkManaged = this.isJerseyExtension(type);
        Preconditions.checkState((!hkManaged ? 1 : 0) != 0, (String)"Resource annotated as jersey managed is declared manually in guice: %s (%s)", (Object)type.getName(), (Object)BindingUtils.getDeclarationSource(binding));
    }

    @Override
    public void install(Environment environment, Class<Object> type) {
        environment.jersey().register(type);
    }

    @Override
    public void install(AbstractBinder binder, Injector injector, Class<Object> type) {
        boolean jerseyManaged = this.isJerseyExtension(type);
        JerseyBinding.bindComponent(binder, injector, type, jerseyManaged, this.isForceSingleton(type, jerseyManaged));
    }

    @Override
    public void report() {
    }

    private boolean hasMatchedInterfaces(Class<?> type) {
        boolean matches = false;
        for (Class<?> iface : type.getInterfaces()) {
            if (!iface.isAnnotationPresent(Path.class)) continue;
            matches = true;
            break;
        }
        return matches;
    }

    @Override
    public List<String> getRecognizableSigns() {
        return Arrays.asList("@" + Path.class.getSimpleName() + " on class", "@" + Path.class.getSimpleName() + " on implemented interface");
    }
}

