/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.support;

import com.google.inject.AbstractModule;
import io.dropwizard.Configuration;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import ru.vyarus.dropwizard.guice.module.context.SharedConfigurationState;
import ru.vyarus.dropwizard.guice.module.context.option.Options;
import ru.vyarus.dropwizard.guice.module.support.BootstrapAwareModule;
import ru.vyarus.dropwizard.guice.module.support.ConfigurationAwareModule;
import ru.vyarus.dropwizard.guice.module.support.ConfigurationTreeAwareModule;
import ru.vyarus.dropwizard.guice.module.support.EnvironmentAwareModule;
import ru.vyarus.dropwizard.guice.module.support.OptionsAwareModule;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public abstract class DropwizardAwareModule<C extends Configuration>
extends AbstractModule
implements EnvironmentAwareModule,
BootstrapAwareModule<C>,
ConfigurationAwareModule<C>,
ConfigurationTreeAwareModule,
OptionsAwareModule {
    private static final String STATE_NOT_FOUND = "Shared state not found";
    private C configuration;
    private Bootstrap<C> bootstrap;
    private Environment environment;
    private Options options;
    private ConfigurationTree configurationTree;

    @Override
    public void setConfiguration(C configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setBootstrap(Bootstrap<C> bootstrap) {
        this.bootstrap = bootstrap;
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public void setOptions(Options options) {
        this.options = options;
    }

    @Override
    public void setConfigurationTree(ConfigurationTree configurationTree) {
        this.configurationTree = configurationTree;
    }

    protected Bootstrap<C> bootstrap() {
        return this.bootstrap;
    }

    protected C configuration() {
        return this.configuration;
    }

    protected <T> T configuration(String yamlPath) {
        return this.configurationTree().valueByPath(yamlPath);
    }

    protected <T, K extends T> K configuration(Class<T> type) {
        return this.configurationTree().valueByUniqueDeclaredType(type);
    }

    protected <T> List<? extends T> configurations(Class<T> type) {
        return this.configurationTree().valuesByType(type);
    }

    protected ConfigurationTree configurationTree() {
        return this.configurationTree;
    }

    protected Environment environment() {
        return this.environment;
    }

    protected String appPackage() {
        return this.bootstrap().getApplication().getClass().getPackage().getName();
    }

    protected Options options() {
        return this.options;
    }

    public void shareState(Class<?> key, Object value) {
        SharedConfigurationState.getOrFail(this.environment(), STATE_NOT_FOUND, new Object[0]).put(key, value);
    }

    public <T> T sharedState(Class<?> key, Supplier<T> defaultValue) {
        return SharedConfigurationState.getOrFail(this.environment(), STATE_NOT_FOUND, new Object[0]).get(key, defaultValue);
    }

    protected <T> Optional<T> sharedState(Class<?> key) {
        return SharedConfigurationState.lookup(this.environment(), key);
    }

    protected <T> T sharedStateOrFail(Class<?> key, String message, Object ... args) {
        return (T)SharedConfigurationState.lookupOrFail(this.environment(), key, message, args);
    }
}

