/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature;

import io.dropwizard.setup.Environment;
import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.util.component.LifeCycle;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.InstanceInstaller;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;
import ru.vyarus.dropwizard.guice.module.installer.order.Ordered;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

@Order(value=10)
public class LifeCycleInstaller
implements FeatureInstaller,
InstanceInstaller<LifeCycle>,
Ordered {
    private final Reporter reporter = new Reporter(LifeCycleInstaller.class, "life cycles =");

    @Override
    public boolean matches(Class<?> type) {
        return FeatureUtils.is(type, LifeCycle.class);
    }

    @Override
    public void install(Environment environment, LifeCycle instance) {
        this.reporter.line(RenderUtils.renderClassLine(FeatureUtils.getInstanceClass(instance)), new Object[0]);
        environment.lifecycle().manage(instance);
    }

    @Override
    public void report() {
        this.reporter.report();
    }

    @Override
    public List<String> getRecognizableSigns() {
        return Collections.singletonList("implements " + LifeCycle.class.getSimpleName());
    }
}

