/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.dropwizard.Application;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.DropwizardTestSupport;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.platform.commons.support.AnnotationSupport;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.dropwizard.guice.test.jupiter.TestDropwizardApp;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestEnvironmentSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.GuiceyExtensionsSupport;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.ExtensionBuilder;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.ExtensionConfig;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.TestExtensionsTracker;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideUtils;
import ru.vyarus.dropwizard.guice.test.util.HooksUtil;
import ru.vyarus.dropwizard.guice.test.util.RandomPortsListener;
import ru.vyarus.dropwizard.guice.test.util.ReusableAppUtils;
import ru.vyarus.dropwizard.guice.test.util.TestSetupUtils;

public class TestDropwizardAppExtension
extends GuiceyExtensionsSupport {
    private static final String STAR = "*";
    private Config config;

    public TestDropwizardAppExtension() {
        super(new TestExtensionsTracker());
    }

    private TestDropwizardAppExtension(Config config) {
        super(config.tracker);
        this.config = config;
    }

    public static Builder forApp(Class<? extends Application> app) {
        return new Builder(app);
    }

    @Override
    protected ExtensionConfig getConfig(ExtensionContext context) {
        if (this.config == null) {
            Optional element = context.getElement();
            TestDropwizardApp ann = AnnotationSupport.findAnnotation((Optional)element, TestDropwizardApp.class).orElse(null);
            Preconditions.checkNotNull((Object)ann, (String)"%s annotation not declared: can't work without configuration, so either use annotation or extension with @%s for manual configuration", (Object)TestDropwizardApp.class.getSimpleName(), (Object)RegisterExtension.class.getSimpleName());
            this.config = Config.parse(ann, this.tracker);
            if (this.config.reuseApp) {
                ReusableAppUtils.registerAnnotation(context.getRequiredTestClass(), ann, this.config);
            }
        }
        if (this.config.reuseApp && this.config.reuseSource == null) {
            ReusableAppUtils.registerField(context.getRequiredTestClass(), this, this.config);
        }
        return this.config;
    }

    @Override
    protected DropwizardTestSupport<?> prepareTestSupport(String configPrefix, ExtensionContext context, List<TestEnvironmentSetup> setups) {
        this.config.extensions.addAll(setups);
        TestSetupUtils.executeSetup(this.config, context);
        HooksUtil.register(this.config.hooks);
        DropwizardTestSupport support = new DropwizardTestSupport(this.config.app, this.config.configPath, configPrefix, this.buildConfigOverrides(configPrefix, context));
        if (this.config.randomPorts) {
            support.addListener((DropwizardTestSupport.ServiceListener)new RandomPortsListener());
        }
        return support;
    }

    private <T extends ConfigOverride> ConfigOverride[] buildConfigOverrides(String prefix, ExtensionContext context) {
        ConfigOverride[] overrides = ConfigOverrideUtils.convert(prefix, this.config.configOverrides);
        if (!Strings.isNullOrEmpty((String)this.config.restMapping)) {
            String mapping = PathUtils.leadingSlash(this.config.restMapping);
            if (!mapping.endsWith(STAR)) {
                mapping = PathUtils.trailingSlash(mapping) + STAR;
            }
            overrides = ConfigOverrideUtils.merge(overrides, ConfigOverride.config((String)prefix, (String)"server.rootPath", (String)mapping));
        }
        return this.config.configOverrideObjects.isEmpty() ? overrides : ConfigOverrideUtils.merge(overrides, ConfigOverrideUtils.prepareExtensionOverrides(ConfigOverrideUtils.prepareOverrides(prefix, this.config.configOverrideObjects), context));
    }

    private static class Config
    extends ExtensionConfig {
        Class<? extends Application> app;
        String configPath = "";
        boolean randomPorts;
        String restMapping = "";

        Config() {
            super(new TestExtensionsTracker());
        }

        Config(TestExtensionsTracker tracker) {
            super(tracker);
        }

        final void extensionInstances(TestEnvironmentSetup ... exts) {
            Collections.addAll(this.extensions, exts);
            this.tracker.extensionInstances(exts);
        }

        @SafeVarargs
        final void extensionsClasses(Class<? extends TestEnvironmentSetup> ... exts) {
            this.extensions.addAll(TestSetupUtils.create(exts));
            this.tracker.extensionClasses(exts);
        }

        static Config parse(TestDropwizardApp ann, TestExtensionsTracker tracker) {
            Config res = new Config(tracker);
            res.app = ann.value();
            res.configPath = ann.config();
            res.configOverrides = ann.configOverride();
            res.randomPorts = ann.randomPorts();
            res.restMapping = ann.restMapping();
            res.hooksFromAnnotation(ann.annotationType(), ann.hooks());
            res.extensionsFromAnnotation(ann.annotationType(), ann.setup());
            res.tracker.debug = ann.debug();
            res.reuseApp = ann.reuseApplication();
            return res;
        }
    }

    public static class Builder
    extends ExtensionBuilder<Builder, Config> {
        public Builder(Class<? extends Application> app) {
            super(new Config());
            ((Config)this.cfg).app = (Class)Preconditions.checkNotNull(app, (Object)"Application class must be provided");
        }

        public Builder config(String configPath) {
            ((Config)this.cfg).configPath = configPath;
            return this;
        }

        public Builder randomPorts(boolean randomPorts) {
            ((Config)this.cfg).randomPorts = randomPorts;
            return this;
        }

        public Builder randomPorts() {
            return this.randomPorts(true);
        }

        public Builder restMapping(String mapping) {
            ((Config)this.cfg).restMapping = mapping;
            return this;
        }

        @SafeVarargs
        public final Builder setup(Class<? extends TestEnvironmentSetup> ... support) {
            ((Config)this.cfg).extensionsClasses(support);
            return this;
        }

        public Builder setup(TestEnvironmentSetup ... support) {
            ((Config)this.cfg).extensionInstances(support);
            return this;
        }

        public TestDropwizardAppExtension create() {
            return new TestDropwizardAppExtension((Config)this.cfg);
        }
    }
}

