/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.bundle;

import com.google.common.base.Preconditions;
import com.google.inject.Module;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.ServerLifecycleListener;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.jetty.util.component.LifeCycle;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.installer.bundle.listener.ApplicationStartupListener;
import ru.vyarus.dropwizard.guice.module.installer.bundle.listener.ApplicationStartupListenerAdapter;
import ru.vyarus.dropwizard.guice.module.installer.bundle.listener.GuiceyStartupListener;
import ru.vyarus.dropwizard.guice.module.installer.bundle.listener.GuiceyStartupListenerAdapter;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleListener;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public class GuiceyEnvironment {
    private final ConfigurationContext context;

    public GuiceyEnvironment(ConfigurationContext context) {
        this.context = context;
    }

    public <T extends Configuration> T configuration() {
        return (T)this.context.getConfiguration();
    }

    public <T> T configuration(String yamlPath) {
        return this.configurationTree().valueByPath(yamlPath);
    }

    public <T, K extends T> K configuration(Class<T> type) {
        return this.configurationTree().valueByUniqueDeclaredType(type);
    }

    public <T> List<? extends T> configurations(Class<T> type) {
        return this.configurationTree().valuesByType(type);
    }

    public ConfigurationTree configurationTree() {
        return this.context.getConfigurationTree();
    }

    public Environment environment() {
        return this.context.getEnvironment();
    }

    public Application application() {
        return this.context.getBootstrap().getApplication();
    }

    public <V, T extends Enum> V option(T option) {
        return this.context.option(option);
    }

    public GuiceyEnvironment modules(Module ... modules) {
        Preconditions.checkState((modules.length > 0 ? 1 : 0) != 0, (Object)"Specify at least one module");
        this.context.registerModules(modules);
        return this;
    }

    public GuiceyEnvironment modulesOverride(Module ... modules) {
        this.context.registerModulesOverride(modules);
        return this;
    }

    public final GuiceyEnvironment disableExtensions(Class<?> ... extensions) {
        this.context.disableExtensions(extensions);
        return this;
    }

    @SafeVarargs
    public final GuiceyEnvironment disableModules(Class<? extends Module> ... modules) {
        this.context.disableModules(modules);
        return this;
    }

    public GuiceyEnvironment register(Object ... items) {
        for (Object item : items) {
            this.environment().jersey().register(item);
        }
        return this;
    }

    public GuiceyEnvironment register(Class<?> ... items) {
        for (Class<?> item : items) {
            this.environment().jersey().register(item);
        }
        return this;
    }

    public GuiceyEnvironment manage(Managed managed) {
        this.environment().lifecycle().manage(managed);
        return this;
    }

    public GuiceyEnvironment listen(GuiceyLifecycleListener ... listeners) {
        this.context.lifecycle().register(listeners);
        return this;
    }

    public GuiceyEnvironment listenServer(ServerLifecycleListener listener) {
        this.environment().lifecycle().addServerLifecycleListener(listener);
        return this;
    }

    public GuiceyEnvironment listenJetty(LifeCycle.Listener listener) {
        this.environment().lifecycle().addEventListener(listener);
        return this;
    }

    public GuiceyEnvironment shareState(Class<?> key, Object value) {
        this.context.getSharedState().put(key, value);
        return this;
    }

    public <T> T sharedState(Class<?> key, Supplier<T> defaultValue) {
        return this.context.getSharedState().get(key, defaultValue);
    }

    public <T> Optional<T> sharedState(Class<?> key) {
        return Optional.ofNullable(this.context.getSharedState().get(key));
    }

    public <T> T sharedStateOrFail(Class<?> key, String message, Object ... args) {
        return (T)this.context.getSharedState().getOrFail(key, message, args);
    }

    public GuiceyEnvironment onGuiceyStartup(GuiceyStartupListener listener) {
        return this.listen(new GuiceyStartupListenerAdapter(listener));
    }

    public GuiceyEnvironment onApplicationStartup(ApplicationStartupListener listener) {
        return this.listen(new ApplicationStartupListenerAdapter(listener));
    }
}

