/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.yaml;

import io.dropwizard.core.Configuration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigPath;

public class ConfigurationTree {
    private static final String DOT = ".";
    private final List<Class> rootTypes;
    private final List<ConfigPath> paths;
    private final List<ConfigPath> uniqueTypePaths;

    public ConfigurationTree(List<Class> rootTypes) {
        this(rootTypes, Collections.emptyList(), Collections.emptyList());
    }

    public ConfigurationTree(List<Class> rootTypes, List<ConfigPath> paths, List<ConfigPath> uniqueTypePaths) {
        this.rootTypes = rootTypes;
        this.paths = paths;
        this.uniqueTypePaths = uniqueTypePaths;
        this.sortContent();
    }

    public List<Class> getRootTypes() {
        return new ArrayList<Class>(this.rootTypes);
    }

    public List<ConfigPath> getPaths() {
        return new ArrayList<ConfigPath>(this.paths);
    }

    public List<ConfigPath> getUniqueTypePaths() {
        return new ArrayList<ConfigPath>(this.uniqueTypePaths);
    }

    public ConfigPath findByPath(String path) {
        return this.paths.stream().filter(it -> it.getPath().equalsIgnoreCase(path)).findFirst().orElse(null);
    }

    public List<ConfigPath> findAllByType(Class<?> type) {
        return this.paths.stream().filter(it -> it.isCustomType() && type.isAssignableFrom(it.getDeclaredType())).collect(Collectors.toList());
    }

    public List<ConfigPath> findAllFrom(Class<? extends Configuration> confType) {
        return this.paths.stream().filter(it -> it.getRootDeclarationClass() == confType).collect(Collectors.toList());
    }

    public List<ConfigPath> findAllRootPaths() {
        return this.paths.stream().filter(it -> !it.getPath().contains(DOT)).collect(Collectors.toList());
    }

    public List<ConfigPath> findAllRootPathsFrom(Class<? extends Configuration> confType) {
        return this.paths.stream().filter(it -> !it.getPath().contains(DOT) && it.getRootDeclarationClass() == confType).collect(Collectors.toList());
    }

    public <T> T valueByPath(String path) {
        ConfigPath item = this.findByPath(path);
        return (T)(item != null ? item.getValue() : null);
    }

    public <T> List<? extends T> valuesByType(Class<T> type) {
        return this.findAllByType(type).stream().map(ConfigPath::getValue).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public <T, K extends T> K valueByType(Class<T> type) {
        List items = this.findAllByType(type).stream().filter(Objects::nonNull).collect(Collectors.toList());
        return (K)(items.isEmpty() ? null : ((ConfigPath)items.get(0)).getValue());
    }

    public <T, K extends T> K valueByUniqueDeclaredType(Class<T> type) {
        return this.uniqueTypePaths.stream().filter(it -> type.equals(it.getDeclaredType())).findFirst().map(ConfigPath::getValue).orElse(null);
    }

    private void sortContent() {
        Comparator comparator = (o1, o2) -> {
            Class rootClass2;
            Class rootClass1 = o1.getRootDeclarationClass();
            int res = !rootClass1.equals(rootClass2 = o2.getRootDeclarationClass()) ? Integer.compare(this.rootTypes.indexOf(rootClass1), this.rootTypes.indexOf(rootClass2)) : o1.getPath().compareTo(o2.getPath());
            return res;
        };
        this.paths.sort(comparator);
        this.uniqueTypePaths.sort(comparator);
    }
}

