/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test;

import com.google.common.base.Preconditions;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.jersey.jackson.JacksonFeature;
import io.dropwizard.testing.DropwizardTestSupport;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;

public class ClientSupport
implements AutoCloseable {
    private static final String HTTP_LOCALHOST = "http://localhost:";
    private final DropwizardTestSupport<?> support;
    private JerseyClient client;

    public ClientSupport(DropwizardTestSupport<?> support) {
        this.support = support;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JerseyClient getClient() {
        ClientSupport clientSupport = this;
        synchronized (clientSupport) {
            if (this.client == null) {
                this.client = this.clientBuilder().build();
            }
            return this.client;
        }
    }

    public int getPort() {
        return this.support.getLocalPort();
    }

    public int getAdminPort() {
        return this.support.getAdminPort();
    }

    public String basePathMain() {
        String contextMapping = this.support.getEnvironment().getApplicationContext().getContextPath();
        return PathUtils.trailingSlash(PathUtils.path(HTTP_LOCALHOST + this.getPort(), contextMapping));
    }

    public String basePathAdmin() {
        String contextMapping = this.support.getEnvironment().getAdminContext().getContextPath();
        return PathUtils.trailingSlash(PathUtils.path(HTTP_LOCALHOST + this.getAdminPort(), contextMapping));
    }

    public String basePathRest() {
        Environment env = this.support.getEnvironment();
        String contextPath = env.getJerseyServletContainer().getServletConfig().getServletContext().getContextPath();
        String restMapping = PathUtils.trailingSlash(PathUtils.trimStars(env.jersey().getUrlPattern()));
        return PathUtils.trailingSlash(PathUtils.path(HTTP_LOCALHOST + this.getPort(), contextPath, restMapping));
    }

    public WebTarget target(String ... paths) {
        Preconditions.checkState((paths.length != 0 ? 1 : 0) != 0, (Object)"Target required (e.g. http://localhost:8080/)");
        return this.getClient().target(PathUtils.path(paths));
    }

    public WebTarget targetMain(String ... paths) {
        return this.target(this.merge(this.basePathMain(), paths));
    }

    public WebTarget targetAdmin(String ... paths) {
        return this.target(this.merge(this.basePathAdmin(), paths));
    }

    public WebTarget targetRest(String ... paths) {
        return this.target(this.merge(this.basePathRest(), paths));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        ClientSupport clientSupport = this;
        synchronized (clientSupport) {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
    }

    private JerseyClientBuilder clientBuilder() {
        return new JerseyClientBuilder().register((Object)new JacksonFeature(this.support.getEnvironment().getObjectMapper())).property("jersey.config.client.connectTimeout", (Object)1000).property("jersey.config.client.readTimeout", (Object)5000).property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
    }

    private String[] merge(String base, String ... addition) {
        String[] res;
        if (addition.length == 0) {
            res = new String[]{base};
        } else {
            res = new String[addition.length + 1];
            res[0] = base;
            System.arraycopy(addition, 0, res, 1, addition.length);
        }
        return res;
    }
}

