/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test;

import com.google.inject.Injector;
import com.google.inject.Key;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.DropwizardTestSupport;
import javax.annotation.Nullable;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorLookup;
import ru.vyarus.dropwizard.guice.test.ClientSupport;
import ru.vyarus.dropwizard.guice.test.GuiceyTestSupport;

public final class TestSupport {
    private TestSupport() {
    }

    public static <C extends Configuration> DropwizardTestSupport<C> webApp(Class<? extends Application<C>> appClass, @Nullable String configPath) {
        return new DropwizardTestSupport(appClass, configPath, new ConfigOverride[0]);
    }

    public static <C extends Configuration> GuiceyTestSupport<C> coreApp(Class<? extends Application<C>> appClass, @Nullable String configPath) {
        return new GuiceyTestSupport(appClass, configPath, new ConfigOverride[0]);
    }

    public static ClientSupport webClient(DropwizardTestSupport<?> support) {
        return new ClientSupport(support);
    }

    public static Injector getInjector(DropwizardTestSupport<?> support) {
        return InjectorLookup.getInjector(support.getApplication()).orElseThrow(() -> new IllegalStateException("Injector not available"));
    }

    public static <T> T getBean(DropwizardTestSupport<?> support, Class<T> type) {
        return TestSupport.getBean(support, Key.get(type));
    }

    public static <T> T getBean(DropwizardTestSupport<?> support, Key<T> key) {
        return (T)TestSupport.getInjector(support).getInstance(key);
    }

    public static void injectBeans(DropwizardTestSupport<?> support, Object target) {
        TestSupport.getInjector(support).injectMembers(target);
    }

    public static <T> T run(DropwizardTestSupport<?> support, @Nullable RunCallback<T> callback) throws Exception {
        support.before();
        try {
            T t = callback != null ? (T)callback.run(TestSupport.getInjector(support)) : null;
            return t;
        }
        finally {
            support.after();
        }
    }

    public static <C extends Configuration> void runWebApp(Class<? extends Application<C>> appClass, @Nullable String configPath) throws Exception {
        TestSupport.runWebApp(appClass, configPath, null);
    }

    public static <T, C extends Configuration> T runWebApp(Class<? extends Application<C>> appClass, @Nullable String configPath, @Nullable RunCallback<T> callback) throws Exception {
        return TestSupport.run(TestSupport.webApp(appClass, configPath), callback);
    }

    public static <C extends Configuration> void runCoreApp(Class<? extends Application<C>> appClass, @Nullable String configPath) throws Exception {
        TestSupport.runCoreApp(appClass, configPath, null);
    }

    public static <T, C extends Configuration> T runCoreApp(Class<? extends Application<C>> appClass, @Nullable String configPath, @Nullable RunCallback<T> callback) throws Exception {
        return TestSupport.run(TestSupport.coreApp(appClass, configPath), callback);
    }

    public static void debugExtensions() {
        System.setProperty("guicey.extensions.debug", "true");
    }

    @FunctionalInterface
    public static interface RunCallback<T> {
        public T run(Injector var1) throws Exception;
    }
}

