/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.guice.util.visitor;

import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.servlet.RequestScoped;
import com.google.inject.servlet.ServletScopes;
import com.google.inject.servlet.SessionScoped;
import com.google.inject.spi.DefaultBindingScopingVisitor;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import ru.vyarus.dropwizard.guice.module.installer.feature.eager.EagerSingleton;
import ru.vyarus.dropwizard.guice.module.support.scope.Prototype;

public class GuiceScopingVisitor
extends DefaultBindingScopingVisitor<Class<? extends Annotation>> {
    public Class<? extends Annotation> visitEagerSingleton() {
        return EagerSingleton.class;
    }

    public Class<? extends Annotation> visitScope(Scope scope) {
        Class res = null;
        if (Scopes.SINGLETON.equals(scope)) {
            res = Singleton.class;
        }
        if (Scopes.NO_SCOPE.equals(scope)) {
            res = Prototype.class;
        }
        if (ServletScopes.REQUEST.equals(scope)) {
            res = RequestScoped.class;
        }
        if (ServletScopes.SESSION.equals(scope)) {
            res = SessionScoped.class;
        }
        return res;
    }

    public Class<? extends Annotation> visitScopeAnnotation(Class scopeAnnotation) {
        if (scopeAnnotation.equals(com.google.inject.Singleton.class)) {
            return Singleton.class;
        }
        return scopeAnnotation;
    }

    public Class<? extends Annotation> visitNoScoping() {
        return Prototype.class;
    }
}

