/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.yaml;

import io.dropwizard.core.Configuration;
import ru.vyarus.dropwizard.guice.debug.report.ReportRenderer;
import ru.vyarus.dropwizard.guice.debug.report.yaml.BindingsConfig;
import ru.vyarus.dropwizard.guice.debug.util.TreeNode;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigPath;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public class ConfigBindingsRenderer
implements ReportRenderer<BindingsConfig> {
    private static final String EQUAL = " = ";
    private static final String CONFIG = "@Config";
    private static final String SPACE = " ";
    private final ConfigurationTree tree;

    public ConfigBindingsRenderer(ConfigurationTree tree) {
        this.tree = tree;
    }

    @Override
    public String renderReport(BindingsConfig config) {
        StringBuilder res = new StringBuilder();
        if (config.isShowConfigurationTree()) {
            this.renderConfigurationTree(config, res);
        }
        if (config.isShowBindings()) {
            this.renderRootTypes(config, res);
            this.renderUniqueSubConfigs(config, res);
            this.renderPaths(config, res);
        }
        return res.toString();
    }

    private void renderConfigurationTree(BindingsConfig config, StringBuilder res) {
        TreeNode node = new TreeNode(this.tree.getRootTypes().get(0).getSimpleName() + " (visible paths)", new Object[0]);
        this.tree.findAllRootPaths().forEach(it -> this.renderSubtree(node, (ConfigPath)it, config));
        if (node.hasChildren()) {
            res.append(Reporter.NEWLINE).append(Reporter.NEWLINE);
            node.render(res);
        }
    }

    private void renderSubtree(TreeNode root, ConfigPath path, BindingsConfig config) {
        if (this.isHidden(path, config)) {
            return;
        }
        StringBuilder name = new StringBuilder().append(path.getLastPathLevel()).append(": ").append(path.toStringType());
        if (!path.isCustomType()) {
            name.append(EQUAL).append(path.toStringValue());
        }
        TreeNode node = root.child(name.toString(), new Object[0]);
        path.getChildren().forEach(it -> this.renderSubtree(node, (ConfigPath)it, config));
    }

    private void renderRootTypes(BindingsConfig config, StringBuilder res) {
        if (this.tree.getRootTypes().size() == 1 && config.isShowCustomConfigOnly()) {
            return;
        }
        res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("Configuration object bindings:").append(Reporter.NEWLINE);
        for (Class type : this.tree.getRootTypes()) {
            if (config.isShowCustomConfigOnly() && type.equals(Configuration.class)) continue;
            res.append("    ").append("    ").append(CONFIG).append(SPACE).append(type.getSimpleName()).append(Reporter.NEWLINE);
        }
    }

    private void renderUniqueSubConfigs(BindingsConfig config, StringBuilder res) {
        boolean header = false;
        for (ConfigPath item : this.tree.getUniqueTypePaths()) {
            if (this.isHidden(item, config)) continue;
            if (!header) {
                res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("Unique sub configuration objects bindings:").append(Reporter.NEWLINE);
                header = true;
            }
            res.append(Reporter.NEWLINE).append("    ").append("    ").append(item.getRootDeclarationClass().getSimpleName()).append('.').append(item.getPath()).append(Reporter.NEWLINE).append("    ").append("    ").append("    ").append(CONFIG).append(SPACE);
            this.renderPath(item, res);
            res.append(Reporter.NEWLINE);
        }
    }

    private void renderPaths(BindingsConfig config, StringBuilder res) {
        boolean header = false;
        Class rootConfig = null;
        for (ConfigPath item : this.tree.getPaths()) {
            if (this.isHidden(item, config)) continue;
            if (!header) {
                res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("Configuration paths bindings:").append(Reporter.NEWLINE);
                header = true;
            }
            if (rootConfig != item.getRootDeclarationClass()) {
                rootConfig = item.getRootDeclarationClass();
                res.append(Reporter.NEWLINE).append("    ").append("    ").append(rootConfig.getSimpleName()).append(':').append(Reporter.NEWLINE);
            }
            res.append("    ").append("    ").append("    ").append(CONFIG).append("(\"").append(item.getPath()).append("\") ");
            this.renderPath(item, res);
            res.append(Reporter.NEWLINE);
        }
    }

    private void renderPath(ConfigPath path, StringBuilder res) {
        res.append(path.toStringDeclaredType()).append(path.isObjectDeclaration() ? Character.valueOf('*') : "");
        if (path.getDeclaredType() != path.getValueType()) {
            res.append(" (with actual type ").append(path.toStringType()).append(')');
        }
        res.append(EQUAL).append(path.toStringValue());
    }

    private boolean isHidden(ConfigPath path, BindingsConfig config) {
        return !config.isShowNullValues() && path.getValue() == null || config.isShowCustomConfigOnly() && path.getRootDeclarationClass().equals(Configuration.class);
    }
}

