/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context;

import com.google.inject.Module;
import io.dropwizard.core.Application;
import io.dropwizard.core.ConfiguredBundle;
import java.util.Arrays;
import ru.vyarus.dropwizard.guice.bundle.GuiceyBundleLookup;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.context.OptionalExtensionDisablerScope;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClasspathScanner;

public enum ConfigScope {
    Application(Application.class),
    BundleLookup(GuiceyBundleLookup.class),
    ClasspathScan(ClasspathScanner.class),
    Hook(GuiceyConfigurationHook.class),
    GuiceyBundle(GuiceyBundle.class),
    DropwizardBundle(ConfiguredBundle.class),
    Module(Module.class),
    OptionalExtensionDisable(OptionalExtensionDisablerScope.class);

    private final Class<?> type;

    private ConfigScope(Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    public ItemId getKey() {
        return ItemId.from(this.getType());
    }

    public static Class[] allExcept(ConfigScope scope) {
        return (Class[])Arrays.stream(ConfigScope.values()).filter(s -> s != scope).map(ConfigScope::getType).toArray(Class[]::new);
    }

    public static ConfigScope recognize(ItemId id) {
        return ConfigScope.recognize(id.getType());
    }

    public static ConfigScope recognize(Class<?> type) {
        for (ConfigScope scope : ConfigScope.values()) {
            if (!scope.getType().isAssignableFrom(type)) continue;
            return scope;
        }
        throw new IllegalStateException("Type " + type.getName() + " does not represent configuration scope");
    }
}

