/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.info.impl;

import java.util.ArrayList;
import java.util.List;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.info.InstanceItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.info.impl.ItemInfoImpl;

public abstract class InstanceItemInfoImpl<T>
extends ItemInfoImpl
implements InstanceItemInfo<T> {
    private final T instance;
    private int instanceCount;
    private final List<ItemId> duplicates = new ArrayList<ItemId>();

    public InstanceItemInfoImpl(ConfigItem itemType, Class type) {
        super(itemType, ItemId.from(type));
        this.instance = null;
    }

    public InstanceItemInfoImpl(ConfigItem itemType, T instance) {
        super(itemType, ItemId.from(instance));
        this.instance = instance;
    }

    @Override
    public T getInstance() {
        return this.instance;
    }

    @Override
    public int getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(int instanceCount) {
        this.instanceCount = instanceCount;
    }

    @Override
    public List<ItemId> getDuplicates() {
        return this.duplicates;
    }

    @Override
    public String toString() {
        return super.toString() + (String)(this.getInstanceCount() > 0 ? " (#" + this.getInstanceCount() + ")" : "");
    }
}

