/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.jersey.debug.service;

import com.google.common.collect.Lists;
import com.google.inject.spi.ProvisionListener;
import jakarta.inject.Inject;
import java.util.List;
import ru.vyarus.dropwizard.guice.module.jersey.debug.service.ContextDebugService;

public class GuiceInstanceListener
implements ProvisionListener {
    private ContextDebugService contextDebugService;
    private final List<Class<?>> created = Lists.newArrayList();

    public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
        Class type = provision.getBinding().getKey().getTypeLiteral().getRawType();
        if (this.contextDebugService == null) {
            this.created.add(type);
        } else {
            this.checkType(type);
        }
    }

    @Inject
    public void setContextDebugService(ContextDebugService contextDebugService) {
        this.contextDebugService = contextDebugService;
        this.checkCollected();
    }

    private void checkCollected() {
        for (Class<?> type : this.created) {
            this.checkType(type);
        }
        this.created.clear();
    }

    private void checkType(Class<?> type) {
        if (this.contextDebugService.getManagedTypes().contains(type)) {
            this.contextDebugService.guiceManage(type);
        }
    }
}

