/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.debug.report.ReportRenderer;
import ru.vyarus.dropwizard.guice.debug.report.diagnostic.DiagnosticConfig;
import ru.vyarus.dropwizard.guice.debug.report.diagnostic.DiagnosticRenderer;
import ru.vyarus.dropwizard.guice.debug.report.option.OptionsConfig;
import ru.vyarus.dropwizard.guice.debug.report.option.OptionsRenderer;
import ru.vyarus.dropwizard.guice.debug.report.stat.StatsRenderer;
import ru.vyarus.dropwizard.guice.debug.report.tree.ContextTreeConfig;
import ru.vyarus.dropwizard.guice.debug.report.tree.ContextTreeRenderer;
import ru.vyarus.dropwizard.guice.module.GuiceyConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleAdapter;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.jersey.ApplicationStartedEvent;

public class ConfigurationDiagnostic
extends GuiceyLifecycleAdapter {
    private final Logger logger = LoggerFactory.getLogger(ConfigurationDiagnostic.class);
    private final String reportTitle;
    private final Boolean statsConfig;
    private final OptionsConfig optionsConfig;
    private final DiagnosticConfig config;
    private final ContextTreeConfig treeConfig;

    public ConfigurationDiagnostic() {
        this(ConfigurationDiagnostic.builder().printStartupStats(true).printOptions(new OptionsConfig().showNotDefinedOptions().showNotUsedMarker()).printConfiguration(new DiagnosticConfig().printDefaults()).printContextTree(new ContextTreeConfig().hideNotUsedInstallers().hideCommands()));
    }

    ConfigurationDiagnostic(Builder builder) {
        this.reportTitle = builder.reportTitle;
        this.statsConfig = builder.statsConfig;
        this.optionsConfig = builder.optionsConfig;
        this.config = builder.config;
        this.treeConfig = builder.treeConfig;
    }

    @Override
    protected void applicationStarted(ApplicationStartedEvent event) {
        StringBuilder res = new StringBuilder(this.reportTitle);
        GuiceyConfigurationInfo info = event.getConfigurationInfo();
        this.report("STARTUP STATS", new StatsRenderer(info), this.statsConfig, res);
        this.report("OPTIONS", new OptionsRenderer(info), this.optionsConfig, res);
        this.report("CONFIGURATION", new DiagnosticRenderer(info), this.config, res);
        this.report("CONFIGURATION TREE", new ContextTreeRenderer(info), this.treeConfig, res);
        this.logger.info(res.toString());
    }

    public boolean equals(Object obj) {
        return obj instanceof ConfigurationDiagnostic && this.reportTitle.equals(((ConfigurationDiagnostic)obj).reportTitle);
    }

    public int hashCode() {
        return this.reportTitle.hashCode();
    }

    public static Builder builder() {
        return new Builder("Diagnostic report");
    }

    public static Builder builder(String reportTitle) {
        return new Builder((String)Preconditions.checkNotNull((Object)reportTitle, (Object)"Report title required"));
    }

    private <T> void report(String name, ReportRenderer<T> renderer, T config, StringBuilder res) {
        if (config != null) {
            res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("---------------------------------------------------------------------------[").append(name).append(']').append(renderer.renderReport(config));
        }
    }

    public static class Builder {
        private final String reportTitle;
        private Boolean statsConfig;
        private OptionsConfig optionsConfig;
        private DiagnosticConfig config;
        private ContextTreeConfig treeConfig;

        public Builder(String reportTitle) {
            this.reportTitle = reportTitle;
        }

        public Builder printStartupStats(boolean hideSmallTimes) {
            this.statsConfig = hideSmallTimes;
            return this;
        }

        public Builder printOptions(OptionsConfig config) {
            this.optionsConfig = config;
            return this;
        }

        public Builder printConfiguration(DiagnosticConfig config) {
            this.config = config;
            Preconditions.checkState((!config.isEmptyConfig() ? 1 : 0) != 0, (Object)"Empty config provided. Use at least one print option.");
            return this;
        }

        public Builder printContextTree(ContextTreeConfig treeConfig) {
            this.treeConfig = treeConfig;
            return this;
        }

        public ConfigurationDiagnostic build() {
            return new ConfigurationDiagnostic(this);
        }
    }
}

