/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.extensions;

import java.util.List;
import ru.vyarus.dropwizard.guice.debug.report.ReportRenderer;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

public class ExtensionsHelpRenderer
implements ReportRenderer<Void> {
    private final List<FeatureInstaller> installers;

    public ExtensionsHelpRenderer(List<FeatureInstaller> installers) {
        this.installers = installers;
    }

    @Override
    public String renderReport(Void config) {
        StringBuilder res = new StringBuilder(Reporter.NEWLINE);
        for (FeatureInstaller installer : this.installers) {
            Class<FeatureInstaller> instType = installer.getClass();
            res.append(Reporter.NEWLINE).append("    ").append(RenderUtils.renderInstaller(instType, null)).append(Reporter.NEWLINE);
            List<String> signs = installer.getRecognizableSigns();
            for (String sign : signs) {
                res.append("    ").append("    ").append(sign).append(Reporter.NEWLINE);
            }
        }
        return res.toString();
    }
}

