/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.guice.model;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ru.vyarus.dropwizard.guice.debug.report.guice.model.DeclarationType;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.GuiceModelUtils;

public class BindingDeclaration {
    private final DeclarationType type;
    private final Object element;
    private Key key;
    private Key target;
    private String providedBy;
    private Class<? extends Annotation> scope;
    private String source;
    private int sourceLine;
    private List<?> special;
    private final List<String> markers = new ArrayList<String>();
    private String module;

    public BindingDeclaration(DeclarationType type, Object element) {
        Preconditions.checkState((boolean)type.getType().isAssignableFrom(element.getClass()), (String)"%s requires %s, but %s binding provided", (Object)type.name(), (Object)type.getType().getSimpleName(), (Object)element.getClass().getSimpleName());
        this.type = type;
        this.element = element;
    }

    public DeclarationType getType() {
        return this.type;
    }

    public Object getElement() {
        return this.element;
    }

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public Key getTarget() {
        return this.target;
    }

    public void setTarget(Key target) {
        this.target = target;
    }

    public String getProvidedBy() {
        return this.providedBy;
    }

    public void setProvidedBy(String providedBy) {
        this.providedBy = providedBy;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public void setScope(Class<? extends Annotation> scope) {
        this.scope = scope;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public int getSourceLine() {
        return this.sourceLine;
    }

    public void setSourceLine(int sourceLine) {
        this.sourceLine = sourceLine;
    }

    public List<?> getSpecial() {
        return this.special;
    }

    public void setSpecial(List<?> special) {
        this.special = special;
    }

    public List<String> getMarkers() {
        return this.markers;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String toString() {
        String res = this.type.name().toLowerCase() + " " + GuiceModelUtils.renderKey(this.key);
        if (this.module != null) {
            res = res + " (from module " + this.module + ")";
        }
        return res;
    }

    public boolean equals(Object o) {
        return o instanceof BindingDeclaration && Objects.equals(this.element, ((BindingDeclaration)o).getElement());
    }

    public int hashCode() {
        return this.element.hashCode();
    }
}

