/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.yaml;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Primitives;
import com.google.inject.BindingAnnotation;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.util.DataSize;
import io.dropwizard.util.Duration;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigPath;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;
import ru.vyarus.java.generics.resolver.GenericsResolver;
import ru.vyarus.java.generics.resolver.context.GenericsContext;

public final class ConfigTreeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigTreeBuilder.class);
    private static final ImmutableSet<String> INTROSPECTION_STOP_PACKAGES = ImmutableSet.of((Object)"java.", (Object)"groovy.", (Object)"com.google.common.collect", (Object)"sun.");
    private static final ImmutableSet<Class> INTROSPECTION_STOP_TYPES = ImmutableSet.of(Iterable.class, Optional.class, Duration.class, DataSize.class);
    private static final ImmutableSet<Class> COMMON_VALUE_TYPES = ImmutableSet.of(List.class, Set.class, Map.class, Multimap.class);

    private ConfigTreeBuilder() {
    }

    public static ConfigurationTree build(Bootstrap bootstrap, Configuration configuration) {
        return ConfigTreeBuilder.build(bootstrap, configuration, true);
    }

    public static ConfigurationTree build(Bootstrap bootstrap, Configuration configuration, boolean introspect) {
        List<Class> roots = ConfigTreeBuilder.resolveRootTypes(new ArrayList<Class>(), configuration.getClass());
        if (introspect) {
            List<ConfigPath> content = ConfigTreeBuilder.resolvePaths(bootstrap.getObjectMapper().getSerializationConfig(), null, new ArrayList<ConfigPath>(), configuration.getClass(), configuration, GenericsResolver.resolve(configuration.getClass(), (Class[])new Class[0]));
            List<ConfigPath> uniqueContent = ConfigTreeBuilder.resolveUniqueTypePaths(content);
            return new ConfigurationTree(roots, content, uniqueContent);
        }
        return new ConfigurationTree(roots);
    }

    private static List<Class> resolveRootTypes(List<Class> roots, Class type) {
        roots.add(type);
        if (type == Configuration.class) {
            return roots;
        }
        for (Class<?> iface : type.getInterfaces()) {
            if (ConfigTreeBuilder.isInStopPackage(iface)) continue;
            roots.add(iface);
        }
        return ConfigTreeBuilder.resolveRootTypes(roots, type.getSuperclass());
    }

    private static List<ConfigPath> resolvePaths(SerializationConfig config, ConfigPath root, List<ConfigPath> content, Class type, Object object, GenericsContext genericsContext) {
        BeanDescription description = config.introspect(config.constructType(type));
        for (BeanPropertyDefinition prop : description.findProperties()) {
            Object value;
            if (!prop.couldSerialize() || "metaClass".equals(prop.getName())) continue;
            try {
                value = ConfigTreeBuilder.readValue(prop.getAccessor(), object);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't bind configuration path '{}' due to {}: {}. Enable debug logs to see complete stack trace or use @JsonIgnore on property getter.", new Object[]{ConfigTreeBuilder.fullPath(root, prop), ex.getClass().getSimpleName(), ex.getMessage()});
                LOGGER.debug("Complete error: ", (Throwable)ex);
                continue;
            }
            ConfigPath item = ConfigTreeBuilder.createItem(root, prop, value, genericsContext);
            content.add(item);
            if (root != null) {
                root.getChildren().add(item);
            }
            if (!item.isCustomType() || ConfigTreeBuilder.detectRecursion(item)) continue;
            GenericsContext subContext = prop.getGetter() != null ? genericsContext.method(prop.getGetter().getAnnotated()).returnTypeAs(item.getValueType()) : genericsContext.fieldTypeAs(prop.getField().getAnnotated(), item.getValueType());
            ConfigTreeBuilder.resolvePaths(config, item, content, item.getValueType(), item.getValue(), subContext);
        }
        if (root != null) {
            root.getChildren().sort(Comparator.comparing(o -> (o.isCustomType() ? (char)'b' : (char)'a') + o.getPath()));
        }
        return content;
    }

    private static boolean detectRecursion(ConfigPath item) {
        if (item.getValue() != null || item.getRoot() == null) {
            return false;
        }
        boolean res = false;
        Class recursiveType = item.getDeclaredType();
        ConfigPath current = item;
        while (current.getRoot() != null) {
            if (!recursiveType.isAssignableFrom((current = current.getRoot()).getDeclaredType())) continue;
            res = true;
            break;
        }
        return res;
    }

    private static ConfigPath createItem(ConfigPath root, BeanPropertyDefinition prop, Object value, GenericsContext genericsContext) {
        Type type = prop.getGetter() != null ? prop.getGetter().getAnnotated().getGenericReturnType() : prop.getField().getAnnotated().getGenericType();
        Class<?> typeClass = Primitives.wrap((Class)genericsContext.resolveClass(type));
        Class<?> upperType = value == null ? typeClass : value.getClass();
        boolean customType = ConfigTreeBuilder.isCustomType(upperType);
        boolean objectDeclared = Object.class.equals(typeClass);
        Class<?> lowerType = ConfigTreeBuilder.correctValueType(objectDeclared ? upperType : typeClass, customType);
        List<Type> lowerGenerics = ConfigTreeBuilder.resolveLowerGenerics(genericsContext, type, typeClass, objectDeclared, lowerType);
        List<Type> upperGenerics = lowerType.equals(upperType) ? lowerGenerics : ConfigTreeBuilder.resolveUpperGenerics(genericsContext, type, objectDeclared, upperType);
        return new ConfigPath(root, prop.getAccessor().getDeclaringClass(), lowerType, upperType.isAnonymousClass() ? lowerType : upperType, lowerGenerics, upperGenerics, ConfigTreeBuilder.fullPath(root, prop), value, customType, objectDeclared, ConfigTreeBuilder.findQualifier(prop));
    }

    private static List<Type> resolveLowerGenerics(GenericsContext genericsContext, Type type, Class typeClass, boolean objectDeclared, Class lowerType) {
        List res = !objectDeclared && !lowerType.equals(typeClass) ? genericsContext.inlyingType(type).type(lowerType).genericTypes() : genericsContext.resolveTypeGenerics(objectDeclared ? lowerType : type);
        return res;
    }

    private static List<Type> resolveUpperGenerics(GenericsContext genericsContext, Type type, boolean objectDeclared, Class upperType) {
        List res = objectDeclared ? genericsContext.resolveTypeGenerics((Type)upperType) : genericsContext.inlyingTypeAs(type, upperType).genericTypes();
        return res;
    }

    private static List<ConfigPath> resolveUniqueTypePaths(List<ConfigPath> items) {
        HashMap<Class, ConfigPath> index = new HashMap<Class, ConfigPath>();
        ArrayList<Class> duplicates = new ArrayList<Class>();
        for (ConfigPath item : items) {
            Class type = item.getDeclaredType();
            if (!item.isCustomType() || duplicates.contains(type)) continue;
            if (index.containsKey(type)) {
                index.remove(type);
                duplicates.add(type);
                continue;
            }
            index.put(type, item);
        }
        return index.isEmpty() ? Collections.emptyList() : new ArrayList(index.values());
    }

    private static boolean isInStopPackage(Class type) {
        boolean res = false;
        String pkg = type.getPackage().getName();
        for (String fnPkg : INTROSPECTION_STOP_PACKAGES) {
            if (!pkg.startsWith(fnPkg)) continue;
            res = true;
            break;
        }
        return res;
    }

    private static boolean isCustomType(Class type) {
        boolean res;
        boolean bl = res = !type.isPrimitive() && !type.isEnum() && !type.isArray();
        if (res) {
            boolean bl2 = res = !ConfigTreeBuilder.isInStopPackage(type);
        }
        if (res) {
            res = ConfigTreeBuilder.findMatchingType(type, INTROSPECTION_STOP_TYPES) == null;
        }
        return res;
    }

    private static Class correctValueType(Class type, boolean custom) {
        Class res = type;
        if (!custom) {
            res = type.isPrimitive() ? Primitives.wrap((Class)type) : (Class)MoreObjects.firstNonNull((Object)ConfigTreeBuilder.findMatchingType(type, COMMON_VALUE_TYPES), (Object)res);
        }
        return res;
    }

    private static Class findMatchingType(Class type, Set<Class> types) {
        Class res = null;
        for (Class val : types) {
            if (!val.isAssignableFrom(type)) continue;
            res = val;
            break;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object readValue(AnnotatedMember member, Object object) {
        Object res;
        if (object == null) {
            return null;
        }
        AccessibleObject accessor = (AccessibleObject)((Object)member.getMember());
        if (!accessor.isAccessible()) {
            accessor.setAccessible(true);
            try {
                res = member.getValue(object);
            }
            finally {
                accessor.setAccessible(false);
            }
        } else {
            res = member.getValue(object);
        }
        return res;
    }

    private static String fullPath(ConfigPath root, BeanPropertyDefinition prop) {
        return (String)(root == null ? "" : root.getPath() + ".") + prop.getName();
    }

    private static Annotation findQualifier(BeanPropertyDefinition prop) {
        Annotation ann = null;
        if (prop.getField() != null) {
            ann = ConfigTreeBuilder.findQualifierAnnotation(prop.getField().getAllAnnotations().annotations());
        }
        if (ann == null && prop.getGetter() != null) {
            ann = ConfigTreeBuilder.findQualifierAnnotation(prop.getGetter().getAllAnnotations().annotations());
        }
        return ann;
    }

    private static Annotation findQualifierAnnotation(Iterable<Annotation> anns) {
        for (Annotation ann : anns) {
            for (Annotation marker : ann.annotationType().getAnnotations()) {
                Class<? extends Annotation> type = marker.annotationType();
                if (!type.equals(Qualifier.class) && !type.equals(BindingAnnotation.class)) continue;
                return ann;
            }
        }
        return null;
    }
}

