/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.jersey;

import com.google.common.collect.ImmutableSet;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.util.LinkedHashSet;
import java.util.Set;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.server.spi.internal.ValueParamProvider;

public class JerseyConfig {
    private static final Set<Class<?>> EXTENSION_TYPES = ImmutableSet.of(ExceptionMapper.class, ParamConverterProvider.class, ContextResolver.class, MessageBodyReader.class, MessageBodyWriter.class, ReaderInterceptor.class, (Object[])new Class[]{WriterInterceptor.class, ContainerRequestFilter.class, ContainerResponseFilter.class, DynamicFeature.class, ValueParamProvider.class, InjectionResolver.class});
    private final Set<Class<?>> types = new LinkedHashSet();

    public JerseyConfig showExceptionMappers() {
        this.types.add(ExceptionMapper.class);
        return this;
    }

    public JerseyConfig showMessageReaders() {
        this.types.add(MessageBodyReader.class);
        return this;
    }

    public JerseyConfig showMessageWriters() {
        this.types.add(MessageBodyWriter.class);
        return this;
    }

    public JerseyConfig showReadInterceptors() {
        this.types.add(ReaderInterceptor.class);
        return this;
    }

    public JerseyConfig showWriteInterceptors() {
        this.types.add(WriterInterceptor.class);
        return this;
    }

    public JerseyConfig showRequestFilters() {
        this.types.add(ContainerRequestFilter.class);
        return this;
    }

    public JerseyConfig showResponseFilters() {
        this.types.add(ContainerResponseFilter.class);
        return this;
    }

    public JerseyConfig showDynamicFeatures() {
        this.types.add(DynamicFeature.class);
        return this;
    }

    public JerseyConfig showContextResolvers() {
        this.types.add(ContextResolver.class);
        return this;
    }

    public JerseyConfig showParamConverters() {
        this.types.add(ParamConverterProvider.class);
        return this;
    }

    public JerseyConfig showParamValueProviders() {
        this.types.add(ValueParamProvider.class);
        return this;
    }

    public JerseyConfig showInjectionResolvers() {
        this.types.add(InjectionResolver.class);
        return this;
    }

    public Set<Class<?>> getRequiredTypes() {
        return this.types.isEmpty() ? EXTENSION_TYPES : this.types;
    }
}

