/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.dropwizard.core.cli.Command;
import io.dropwizard.core.setup.Bootstrap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.GuiceyOptions;
import ru.vyarus.dropwizard.guice.bundle.GuiceyBundleLookup;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.option.Options;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.installer.CoreInstallersBundle;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.internal.CommandSupport;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsHolder;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsSupport;
import ru.vyarus.dropwizard.guice.module.installer.option.WithOptions;
import ru.vyarus.dropwizard.guice.module.installer.order.OrderComparator;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClassVisitor;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClasspathScanner;
import ru.vyarus.dropwizard.guice.module.installer.util.BundleSupport;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.InstanceUtils;

public class GuiceyInitializer {
    public static final String APP_PKG = "<app>";
    private static final OrderComparator COMPARATOR = new OrderComparator();
    private final Logger logger = LoggerFactory.getLogger(GuiceyInitializer.class);
    private final Stopwatch guiceyTimer;
    private final Stopwatch confTimer;
    private final Bootstrap bootstrap;
    private final ConfigurationContext context;
    private final ClasspathScanner scanner;

    public GuiceyInitializer(Bootstrap bootstrap, ConfigurationContext context) {
        this.guiceyTimer = context.stat().timer(Stat.GuiceyTime);
        this.confTimer = context.stat().timer(Stat.ConfigurationTime);
        context.initPhaseStarted(bootstrap);
        this.bootstrap = bootstrap;
        this.context = context;
        String[] packages = (String[])context.option(GuiceyOptions.ScanPackages);
        if (packages.length == 1 && APP_PKG.equals(packages[0])) {
            packages[0] = bootstrap.getApplication().getClass().getPackage().getName();
        }
        this.scanner = packages.length > 0 ? new ClasspathScanner(Sets.newHashSet(Arrays.asList(packages)), context.stat()) : null;
    }

    public void initializeBundles(GuiceyBundleLookup bundleLookup) {
        Stopwatch timer = this.context.stat().timer(Stat.BundleTime);
        Stopwatch resolutionTimer = this.context.stat().timer(Stat.BundleResolutionTime);
        if (((Boolean)this.context.option(GuiceyOptions.UseCoreInstallers)).booleanValue()) {
            this.context.registerBundles(new CoreInstallersBundle());
        }
        this.context.registerLookupBundles(bundleLookup.lookup());
        resolutionTimer.stop();
        Stopwatch btime = this.context.stat().timer(Stat.GuiceyBundleInitTime);
        BundleSupport.initBundles(this.context);
        btime.stop();
        timer.stop();
    }

    public void findCommands() {
        boolean searchCommands = (Boolean)this.context.option(GuiceyOptions.SearchCommands);
        if (searchCommands) {
            Preconditions.checkState((this.scanner != null ? 1 : 0) != 0, (Object)"Commands search could not be performed, because auto scan was not activated");
            List<Command> installed = CommandSupport.registerCommands(this.bootstrap, this.scanner, this.context);
            this.context.lifecycle().commandsResolved(installed);
        }
    }

    public void resolveInstallers() {
        Stopwatch timer = this.context.stat().timer(Stat.InstallersTime);
        List<Class<? extends FeatureInstaller>> installerClasses = this.findInstallers();
        List<FeatureInstaller> installers = this.prepareInstallers(installerClasses);
        this.context.installersResolved(installers);
        timer.stop();
    }

    public void resolveExtensions() {
        Stopwatch itimer = this.context.stat().timer(Stat.InstallersTime);
        Stopwatch timer = this.context.stat().timer(Stat.ExtensionsRecognitionTime);
        ExtensionsHolder holder = this.context.getExtensionsHolder();
        List<Class<?>> manual = this.context.getEnabledExtensions();
        for (Class<?> type2 : manual) {
            if (ExtensionsSupport.registerExtension(this.context, type2, false)) continue;
            throw new IllegalStateException("No installer found for extension " + type2.getName() + ". Available installers: " + holder.getInstallerTypes().stream().map(FeatureUtils::getInstallerExtName).collect(Collectors.joining(", ")));
        }
        this.context.lifecycle().manualExtensionsValidated(this.context.getItems(ConfigItem.Extension), manual);
        if (this.scanner != null) {
            ArrayList extensions = new ArrayList();
            this.scanner.scan(type -> {
                if (manual.contains(type)) {
                    this.context.getOrRegisterExtension(type, true);
                    extensions.add(type);
                } else if (ExtensionsSupport.registerExtension(this.context, type, true)) {
                    extensions.add(type);
                }
            });
            this.context.lifecycle().classpathExtensionsResolved(extensions);
        }
        timer.stop();
        itimer.stop();
    }

    public void initFinished() {
        if (this.scanner != null) {
            this.scanner.cleanup();
        }
        this.context.lifecycle().initialized();
        this.confTimer.stop();
        this.guiceyTimer.stop();
    }

    private List<Class<? extends FeatureInstaller>> findInstallers() {
        List<Object> installers;
        if (this.scanner != null) {
            installers = Lists.newArrayList();
            this.scanner.scan(new ClassVisitor(){

                @Override
                public void visit(Class<?> type) {
                    if (FeatureUtils.is(type, FeatureInstaller.class)) {
                        installers.add(type);
                    }
                }
            });
            installers.sort(Comparator.comparing(Class::getName));
            this.context.registerInstallersFromScan(installers);
        }
        installers = this.context.getEnabledInstallers();
        installers.sort(COMPARATOR);
        this.logger.debug("Found {} installers", (Object)installers.size());
        return installers;
    }

    private List<FeatureInstaller> prepareInstallers(List<Class<? extends FeatureInstaller>> installerClasses) {
        ArrayList installers = Lists.newArrayList();
        Options options = new Options(this.context.options());
        for (Class<? extends FeatureInstaller> installerClass : installerClasses) {
            try {
                FeatureInstaller installer = InstanceUtils.create(installerClass);
                installers.add(installer);
                if (!WithOptions.class.isAssignableFrom(installerClass)) continue;
                ((WithOptions)((Object)installer)).setOptions(options);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to register installer " + installerClass.getName(), e);
            }
        }
        return installers;
    }
}

