/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.scanner;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.context.stat.StatsTracker;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClassVisitor;
import ru.vyarus.dropwizard.guice.module.installer.scanner.InvisibleForScanner;
import ru.vyarus.dropwizard.guice.module.installer.scanner.util.OReflectionHelper;

@SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
public class ClasspathScanner {
    private static final int SCAN_THRESHOLD = 1000;
    private final Logger logger = LoggerFactory.getLogger(ClasspathScanner.class);
    private final StatsTracker tracker;
    private final Set<String> packages;
    private List<Class> scanned;

    public ClasspathScanner(Set<String> packages) {
        this(packages, null);
    }

    public ClasspathScanner(Set<String> packages, StatsTracker tracker) {
        this.packages = this.validate(packages);
        this.tracker = tracker;
        this.performScan();
    }

    public void scan(ClassVisitor visitor) {
        if (this.scanned == null) {
            this.performScan();
        }
        for (Class cls : this.scanned) {
            visitor.visit(cls);
        }
    }

    public void cleanup() {
        this.scanned = null;
    }

    private Set<String> validate(Set<String> packages) {
        ArrayList pkg = Lists.newArrayList(packages);
        Collections.sort(pkg, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.compare(o1.length(), o2.length());
            }
        });
        for (int i = 0; i < pkg.size(); ++i) {
            String path = (String)pkg.get(i);
            for (int j = i + 1; j < pkg.size(); ++j) {
                String path2 = (String)pkg.get(j);
                Preconditions.checkState((!path2.startsWith(path + ".") ? 1 : 0) != 0, (String)"Autoscan path '%s' is already covered by '%s' and may lead to duplicate instances in runtime", (Object)path2, (Object)path);
            }
        }
        return packages;
    }

    private void performScan() {
        Stopwatch timer = this.tracker == null ? null : this.tracker.timer(Stat.ScanTime);
        int count = 0;
        this.scanned = Lists.newArrayList();
        for (String pkg : this.packages) {
            List<Class<?>> found;
            try {
                found = OReflectionHelper.getClassesFor(pkg, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Failed to scan classpath", e);
            }
            count += found.size();
            for (Class<?> cls : found) {
                boolean isInner = cls.getEnclosingClass() != null && !Modifier.isStatic(cls.getModifiers());
                if (isInner || cls.isAnnotationPresent(InvisibleForScanner.class)) continue;
                this.scanned.add(cls);
            }
        }
        if (count > 1000) {
            this.logger.warn("{} classes were loaded while scanning '{}' packages. Reduce packages to scan to increase efficiency.", (Object)count, (Object)Joiner.on((char)',').join(this.packages));
        }
        if (timer != null) {
            timer.stop();
            this.tracker.count(Stat.ScanClassesCount, count);
        }
    }
}

