/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.lifecycle.internal;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.cli.Command;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.util.component.LifeCycle;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.context.SharedConfigurationState;
import ru.vyarus.dropwizard.guice.module.context.option.Options;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycle;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleListener;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.GuiceyLifecycleEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.BundlesFromLookupResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.BundlesInitializedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.BundlesResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.ClasspathExtensionsResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.CommandsResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.ConfigurationHooksProcessedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.DropwizardBundlesInitializedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.InitializedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.InstallersResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.ManualExtensionsValidatedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.jersey.ApplicationShutdownEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.jersey.ApplicationStartedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.jersey.ApplicationStoppedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.jersey.JerseyConfigurationEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.jersey.JerseyExtensionsInstalledByEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.jersey.JerseyExtensionsInstalledEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ApplicationRunEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.BeforeRunEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.BundlesStartedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ExtensionsInstalledByEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ExtensionsInstalledEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ExtensionsResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.InjectorCreationEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ModulesAnalyzedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.internal.EventsContext;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public final class LifecycleSupport {
    private final Logger logger = LoggerFactory.getLogger(LifecycleSupport.class);
    private final EventsContext context;
    private GuiceyLifecycle currentStage;
    private final Set<GuiceyLifecycleListener> listeners = new LinkedHashSet<GuiceyLifecycleListener>();

    public LifecycleSupport(Options options, SharedConfigurationState sharedState) {
        this.context = new EventsContext(options, sharedState);
    }

    public void register(GuiceyLifecycleListener ... listeners) {
        Arrays.asList(listeners).forEach(l -> {
            if (!this.listeners.add((GuiceyLifecycleListener)l)) {
                this.logger.info("IGNORE duplicate lifecycle listener registration: {}", (Object)l.getClass().getName());
            }
        });
    }

    public void configurationHooksProcessed(Set<GuiceyConfigurationHook> hooks) {
        if (hooks != null && !hooks.isEmpty()) {
            this.broadcast(new ConfigurationHooksProcessedEvent(this.context, hooks));
        }
    }

    public void initializationStarted(Bootstrap bootstrap, List<ConfiguredBundle> bundles, List<ConfiguredBundle> disabled, List<ConfiguredBundle> ignored) {
        this.context.setBootstrap(bootstrap);
        if (!bundles.isEmpty()) {
            this.broadcast(new DropwizardBundlesInitializedEvent(this.context, bundles, disabled, ignored));
        }
    }

    public void bundlesFromLookupResolved(List<GuiceyBundle> bundles) {
        if (!bundles.isEmpty()) {
            this.broadcast(new BundlesFromLookupResolvedEvent(this.context, bundles));
        }
    }

    public void bundlesResolved(List<GuiceyBundle> bundles, List<GuiceyBundle> disabled, List<GuiceyBundle> ignored) {
        this.broadcast(new BundlesResolvedEvent(this.context, bundles, disabled, ignored));
    }

    public void bundlesInitialized(List<GuiceyBundle> bundles, List<GuiceyBundle> disabled, List<GuiceyBundle> ignored) {
        if (!bundles.isEmpty()) {
            this.broadcast(new BundlesInitializedEvent(this.context, bundles, disabled, ignored));
        }
    }

    public void commandsResolved(List<Command> installed) {
        if (installed != null && !installed.isEmpty()) {
            this.broadcast(new CommandsResolvedEvent(this.context, installed));
        }
    }

    public void installersResolved(List<FeatureInstaller> installers, List<Class<? extends FeatureInstaller>> disabled) {
        this.broadcast(new InstallersResolvedEvent(this.context, installers, disabled));
    }

    public void manualExtensionsValidated(List<Class<?>> extensions, List<Class<?>> validated) {
        if (!extensions.isEmpty()) {
            this.broadcast(new ManualExtensionsValidatedEvent(this.context, extensions, validated));
        }
    }

    public void classpathExtensionsResolved(List<Class<?>> extensions) {
        if (!extensions.isEmpty()) {
            this.broadcast(new ClasspathExtensionsResolvedEvent(this.context, extensions));
        }
    }

    public void initialized() {
        this.broadcast(new InitializedEvent(this.context));
    }

    public void runPhase(Configuration configuration, ConfigurationTree configurationTree, Environment environment) {
        this.context.setConfiguration(configuration);
        this.context.setConfigurationTree(configurationTree);
        this.context.setEnvironment(environment);
        this.broadcast(new BeforeRunEvent(this.context));
        environment.lifecycle().addEventListener(new LifeCycle.Listener(){

            public void lifeCycleStarted(LifeCycle event) {
                LifecycleSupport.this.applicationStarted();
            }

            public void lifeCycleStopping(LifeCycle event) {
                LifecycleSupport.this.applicationShutdown();
            }

            public void lifeCycleStopped(LifeCycle event) {
                LifecycleSupport.this.applicationStopped();
            }
        });
    }

    public void bundlesStarted(List<GuiceyBundle> bundles) {
        if (!bundles.isEmpty()) {
            this.broadcast(new BundlesStartedEvent(this.context, bundles));
        }
    }

    public void modulesAnalyzed(List<Module> modules, List<Class<?>> extensions, List<Class<? extends Module>> transitiveModulesRemoved, List<Binding> bindingsRemoved) {
        this.broadcast(new ModulesAnalyzedEvent(this.context, modules, extensions, transitiveModulesRemoved, bindingsRemoved));
    }

    public void extensionsResolved(List<Class<?>> extensions, List<Class<?>> disabled) {
        this.broadcast(new ExtensionsResolvedEvent(this.context, extensions, disabled));
    }

    public void injectorCreation(List<Module> modules, List<Module> overriding, List<Module> disabled, List<Module> ignored) {
        this.broadcast(new InjectorCreationEvent(this.context, modules, overriding, disabled, ignored));
    }

    public void injectorPhase(Injector injector) {
        this.context.setInjector(injector);
    }

    public void extensionsInstalled(Class<? extends FeatureInstaller> installer, List<Class<?>> installed) {
        if (installed != null && !installed.isEmpty()) {
            this.broadcast(new ExtensionsInstalledByEvent(this.context, installer, installed));
        }
    }

    public void extensionsInstalled(List<Class<?>> extensions) {
        if (!extensions.isEmpty()) {
            this.broadcast(new ExtensionsInstalledEvent(this.context, extensions));
        }
    }

    public void applicationRun() {
        this.broadcast(new ApplicationRunEvent(this.context));
    }

    public void jerseyConfiguration(InjectionManager injectionManager) {
        this.context.setInjectionManager(injectionManager);
        this.broadcast(new JerseyConfigurationEvent(this.context));
    }

    public void jerseyExtensionsInstalled(Class<? extends FeatureInstaller> installer, List<Class<?>> installed) {
        if (installed != null && !installed.isEmpty()) {
            this.broadcast(new JerseyExtensionsInstalledByEvent(this.context, installer, installed));
        }
    }

    public void jerseyExtensionsInstalled(List<Class<?>> extensions) {
        if (!extensions.isEmpty()) {
            this.broadcast(new JerseyExtensionsInstalledEvent(this.context, extensions));
        }
    }

    public GuiceyLifecycle getStage() {
        return this.currentStage;
    }

    private void broadcast(GuiceyLifecycleEvent event) {
        this.listeners.forEach(l -> l.onEvent(event));
        this.currentStage = event.getType();
    }

    private void applicationStarted() {
        this.broadcast(new ApplicationStartedEvent(this.context));
    }

    private void applicationShutdown() {
        this.broadcast(new ApplicationShutdownEvent(this.context));
    }

    private void applicationStopped() {
        this.broadcast(new ApplicationStoppedEvent(this.context));
    }
}

