/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test;

import com.google.inject.Injector;
import com.google.inject.Key;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.testing.DropwizardTestSupport;
import jakarta.annotation.Nullable;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorLookup;
import ru.vyarus.dropwizard.guice.test.ClientSupport;
import ru.vyarus.dropwizard.guice.test.GuiceyTestSupport;
import ru.vyarus.dropwizard.guice.test.builder.TestSupportBuilder;
import ru.vyarus.dropwizard.guice.test.builder.TestSupportHolder;
import ru.vyarus.dropwizard.guice.test.client.TestClientFactory;
import ru.vyarus.dropwizard.guice.test.cmd.CommandRunBuilder;
import ru.vyarus.dropwizard.guice.test.util.RunResult;
import ru.vyarus.dropwizard.guice.test.util.io.EchoStream;

public final class TestSupport {
    private TestSupport() {
    }

    public static <C extends Configuration> TestSupportBuilder<C> build(Class<? extends Application<C>> app) {
        return new TestSupportBuilder(app);
    }

    public static <C extends Configuration> CommandRunBuilder<C> buildCommandRunner(Class<? extends Application<C>> app) {
        return new CommandRunBuilder(app);
    }

    public static <C extends Configuration> DropwizardTestSupport<C> getContext() {
        return TestSupportHolder.getContext();
    }

    public static ClientSupport getContextClient() {
        return TestSupportHolder.getClient();
    }

    public static <C extends Configuration> DropwizardTestSupport<C> webApp(Class<? extends Application<C>> appClass, @Nullable String configPath, String ... overrides) {
        return ((TestSupportBuilder)((TestSupportBuilder)TestSupport.build(appClass).config(configPath)).configOverrides(overrides)).buildWeb();
    }

    public static <C extends Configuration> GuiceyTestSupport<C> coreApp(Class<? extends Application<C>> appClass, @Nullable String configPath, String ... overrides) {
        return ((TestSupportBuilder)((TestSupportBuilder)TestSupport.build(appClass).config(configPath)).configOverrides(overrides)).buildCore();
    }

    public static ClientSupport webClient(DropwizardTestSupport<?> support) {
        return new ClientSupport(support);
    }

    public static ClientSupport webClient(DropwizardTestSupport<?> support, TestClientFactory factory) {
        return new ClientSupport(support, factory);
    }

    public static Injector getInjector(DropwizardTestSupport<?> support) {
        return InjectorLookup.getInjector(support.getApplication()).orElseThrow(() -> new IllegalStateException("Injector not available"));
    }

    public static <T> T getBean(DropwizardTestSupport<?> support, Class<T> type) {
        return TestSupport.getBean(support, Key.get(type));
    }

    public static <T> T getBean(DropwizardTestSupport<?> support, Key<T> key) {
        return (T)TestSupport.getInjector(support).getInstance(key);
    }

    public static void injectBeans(DropwizardTestSupport<?> support, Object target) {
        TestSupport.getInjector(support).injectMembers(target);
    }

    public static <C extends Configuration> RunResult<C> run(DropwizardTestSupport<C> support) throws Exception {
        return TestSupport.run(support, injector -> new RunResult(TestSupport.getContext(), injector));
    }

    public static <T> T run(DropwizardTestSupport<?> support, @Nullable RunCallback<T> callback) throws Exception {
        return TestSupport.run(support, null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T run(DropwizardTestSupport<?> support, @Nullable TestClientFactory clientFactory, @Nullable RunCallback<T> callback) throws Exception {
        try {
            TestSupportHolder.setContext(support, clientFactory);
            support.before();
            T t = callback != null ? (T)callback.run(TestSupport.getInjector(support)) : null;
            return t;
        }
        finally {
            support.after();
            TestSupportHolder.reset();
        }
    }

    public static <C extends Configuration> RunResult<C> runWebApp(Class<? extends Application<C>> appClass) throws Exception {
        return TestSupport.runWebApp(appClass, (String)null, new String[0]);
    }

    public static <T, C extends Configuration> T runWebApp(Class<? extends Application<C>> appClass, @Nullable RunCallback<T> callback) throws Exception {
        return TestSupport.runWebApp(appClass, null, callback, new String[0]);
    }

    public static <C extends Configuration> RunResult<C> runWebApp(Class<? extends Application<C>> appClass, @Nullable String configPath, String ... overrides) throws Exception {
        return TestSupport.run(TestSupport.webApp(appClass, configPath, overrides));
    }

    public static <T, C extends Configuration> T runWebApp(Class<? extends Application<C>> appClass, @Nullable String configPath, @Nullable RunCallback<T> callback, String ... overrides) throws Exception {
        return TestSupport.run(TestSupport.webApp(appClass, configPath, overrides), callback);
    }

    public static <C extends Configuration> RunResult<C> runCoreApp(Class<? extends Application<C>> appClass) throws Exception {
        return TestSupport.runCoreApp(appClass, (String)null, new String[0]);
    }

    public static <T, C extends Configuration> T runCoreApp(Class<? extends Application<C>> appClass, @Nullable RunCallback<T> callback) throws Exception {
        return TestSupport.runCoreApp(appClass, null, callback, new String[0]);
    }

    public static <C extends Configuration> RunResult<C> runCoreApp(Class<? extends Application<C>> appClass, @Nullable String configPath, String ... overrides) throws Exception {
        return TestSupport.run(TestSupport.coreApp(appClass, configPath, overrides));
    }

    public static <T, C extends Configuration> T runCoreApp(Class<? extends Application<C>> appClass, @Nullable String configPath, @Nullable RunCallback<T> callback, String ... overrides) throws Exception {
        return TestSupport.run(TestSupport.coreApp(appClass, configPath, overrides), callback);
    }

    public static void debugExtensions() {
        System.setProperty("guicey.extensions.debug", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String captureOutput(OutputCallback action) throws Exception {
        PrintStream originalOut = System.out;
        PrintStream originalErr = System.err;
        EchoStream stdOut = new EchoStream(originalOut);
        EchoStream stdErr = new EchoStream(stdOut);
        System.setOut(new PrintStream((OutputStream)stdOut, false, StandardCharsets.UTF_8));
        System.setErr(new PrintStream((OutputStream)stdErr, false, StandardCharsets.UTF_8));
        try {
            action.run();
            String string = stdOut.toString();
            return string;
        }
        finally {
            System.setOut(originalOut);
            System.setErr(originalErr);
        }
    }

    @FunctionalInterface
    public static interface OutputCallback {
        public void run() throws Exception;
    }

    @FunctionalInterface
    public static interface RunCallback<T> {
        public T run(Injector var1) throws Exception;
    }
}

