/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.client;

import io.dropwizard.jersey.jackson.JacksonFeature;
import io.dropwizard.testing.DropwizardTestSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.logging.LoggingFeature;
import ru.vyarus.dropwizard.guice.test.ClientSupport;
import ru.vyarus.dropwizard.guice.test.client.TestClientFactory;

public class DefaultTestClientFactory
implements TestClientFactory {
    public static final String USE_LOGGER = "USE_LOGGER_FOR_CLIENT";

    public static void disableConsoleLog() {
        System.setProperty(USE_LOGGER, "true");
    }

    public static void enableConsoleLog() {
        System.clearProperty(USE_LOGGER);
    }

    @Override
    public JerseyClient create(DropwizardTestSupport<?> support) {
        JerseyClientBuilder builder = new JerseyClientBuilder().register((Object)new JacksonFeature(support.getEnvironment().getObjectMapper())).register((Object)LoggingFeature.builder().withLogger(System.getProperty(USE_LOGGER) != null ? Logger.getLogger(ClientSupport.class.getName()) : new ConsoleLogger()).verbosity(LoggingFeature.Verbosity.PAYLOAD_TEXT).level(Level.INFO).build()).property("jersey.config.client.connectTimeout", (Object)1000).property("jersey.config.client.readTimeout", (Object)5000).property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
        try {
            Class<?> cls = Class.forName("org.glassfish.jersey.media.multipart.MultiPartFeature");
            builder.register(cls);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return builder.build();
    }

    public static class ConsoleLogger
    extends Logger {
        public ConsoleLogger() {
            super(ClientSupport.class.getName(), null);
        }

        @Override
        public boolean isLoggable(Level level) {
            return true;
        }

        @Override
        public void log(Level level, String msg) {
            System.out.println("\n[Client action]---------------------------------------------{");
            System.out.println(msg);
            System.out.println("}----------------------------------------------------------\n");
        }
    }
}

