/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.util;

import com.google.common.base.Preconditions;
import io.dropwizard.testing.ConfigOverride;
import jakarta.annotation.Nullable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideExtensionValue;
import ru.vyarus.dropwizard.guice.test.util.ConfigurablePrefix;

public final class ConfigOverrideUtils {
    private static final String STAR = "*";

    private ConfigOverrideUtils() {
    }

    public static String createPrefix(ExtensionContext context) {
        Optional method = context.getTestMethod();
        Object prefix = method.map(Method::getName).orElseGet(() -> RenderUtils.getClassName(context.getRequiredTestClass()));
        if (context.getParent().isPresent() && ((ExtensionContext)context.getParent().get()).getTestClass().isPresent()) {
            prefix = ConfigOverrideUtils.createPrefix((ExtensionContext)context.getParent().get()) + "." + (String)prefix;
        }
        return prefix;
    }

    public static ConfigOverride[] convert(String prefix, String ... props) {
        ConfigOverride[] overrides = null;
        if (props != null && props.length > 0) {
            overrides = new ConfigOverride[props.length];
            int i = 0;
            for (String value : props) {
                int idx = value.indexOf(58);
                Preconditions.checkState((idx > 0 ? 1 : 0) != 0, (String)"Incorrect configuration override declaration: must be 'key: value', but found '%s'", (Object)value);
                overrides[i++] = ConfigOverride.config((String)prefix, (String)value.substring(0, idx).trim(), (String)value.substring(idx + 1).trim());
            }
        }
        return overrides;
    }

    public static String[] mergeRaw(String[] base, String ... addition) {
        if (addition == null || addition.length == 0) {
            return base;
        }
        if (base == null || base.length == 0) {
            return addition;
        }
        String[] res = new String[base.length + addition.length];
        System.arraycopy(base, 0, res, 0, base.length);
        System.arraycopy(addition, 0, res, base.length, addition.length);
        return res;
    }

    public static ConfigOverride[] merge(ConfigOverride[] base, ConfigOverride ... addition) {
        if (addition == null || addition.length == 0) {
            return base;
        }
        if (base == null) {
            return addition;
        }
        ConfigOverride[] res = new ConfigOverride[base.length + addition.length];
        System.arraycopy(base, 0, res, 0, base.length);
        System.arraycopy(addition, 0, res, base.length, addition.length);
        return res;
    }

    public static <T extends ConfigOverride> ConfigOverride[] prepareOverrides(String prefix, List<T> values) {
        ConfigOverride[] res = null;
        if (!values.isEmpty()) {
            res = new ConfigOverride[values.size()];
            int i = 0;
            for (ConfigOverride value : values) {
                ((ConfigurablePrefix)value).setPrefix(prefix);
                res[i++] = value;
            }
        }
        return res;
    }

    public static ConfigOverride[] prepareExtensionOverrides(ConfigOverride[] overrides, ExtensionContext context) {
        if (overrides != null) {
            for (ConfigOverride override : overrides) {
                if (!(override instanceof ConfigOverrideExtensionValue)) continue;
                ((ConfigOverrideExtensionValue)override).resolveValue(context);
            }
        }
        return overrides;
    }

    public static ConfigOverride overrideRestMapping(@Nullable String prefix, String restMapping) {
        Object mapping = PathUtils.leadingSlash(restMapping);
        if (!((String)mapping).endsWith(STAR)) {
            mapping = PathUtils.trailingSlash((String)mapping) + STAR;
        }
        return ConfigOverride.config((String)(prefix == null ? "dw." : prefix), (String)"server.rootPath", (String)mapping);
    }
}

