/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.lifecycle.ServerLifecycleListener;
import jakarta.servlet.DispatcherType;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.jetty.util.component.LifeCycle;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import ru.vyarus.dropwizard.guice.GuiceyOptions;
import ru.vyarus.dropwizard.guice.bundle.DefaultBundleLookup;
import ru.vyarus.dropwizard.guice.bundle.GuiceyBundleLookup;
import ru.vyarus.dropwizard.guice.bundle.lookup.VoidBundleLookup;
import ru.vyarus.dropwizard.guice.debug.ConfigurationDiagnostic;
import ru.vyarus.dropwizard.guice.debug.ExtensionsHelpDiagnostic;
import ru.vyarus.dropwizard.guice.debug.GuiceAopDiagnostic;
import ru.vyarus.dropwizard.guice.debug.GuiceBindingsDiagnostic;
import ru.vyarus.dropwizard.guice.debug.GuiceProvisionDiagnostic;
import ru.vyarus.dropwizard.guice.debug.JerseyConfigDiagnostic;
import ru.vyarus.dropwizard.guice.debug.LifecycleDiagnostic;
import ru.vyarus.dropwizard.guice.debug.SharedStateDiagnostic;
import ru.vyarus.dropwizard.guice.debug.StartupTimeDiagnostic;
import ru.vyarus.dropwizard.guice.debug.WebMappingsDiagnostic;
import ru.vyarus.dropwizard.guice.debug.YamlBindingsDiagnostic;
import ru.vyarus.dropwizard.guice.debug.hook.DiagnosticHook;
import ru.vyarus.dropwizard.guice.debug.hook.GuiceProvisionTimeHook;
import ru.vyarus.dropwizard.guice.debug.hook.StartupTimeHook;
import ru.vyarus.dropwizard.guice.debug.report.diagnostic.DiagnosticConfig;
import ru.vyarus.dropwizard.guice.debug.report.guice.GuiceAopConfig;
import ru.vyarus.dropwizard.guice.debug.report.guice.GuiceConfig;
import ru.vyarus.dropwizard.guice.debug.report.tree.ContextTreeConfig;
import ru.vyarus.dropwizard.guice.debug.report.web.MappingsConfig;
import ru.vyarus.dropwizard.guice.debug.report.yaml.BindingsConfig;
import ru.vyarus.dropwizard.guice.hook.ConfigurationHooksSupport;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.injector.DefaultInjectorFactory;
import ru.vyarus.dropwizard.guice.injector.InjectorFactory;
import ru.vyarus.dropwizard.guice.module.GuiceyInitializer;
import ru.vyarus.dropwizard.guice.module.GuiceyRunner;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.SharedConfigurationState;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;
import ru.vyarus.dropwizard.guice.module.context.option.Option;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.context.unique.DuplicateConfigDetector;
import ru.vyarus.dropwizard.guice.module.context.unique.UniqueItemsDuplicatesDetector;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.InstallersOptions;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyEnvironment;
import ru.vyarus.dropwizard.guice.module.installer.bundle.listener.ApplicationShutdownListener;
import ru.vyarus.dropwizard.guice.module.installer.bundle.listener.ApplicationShutdownListenerAdapter;
import ru.vyarus.dropwizard.guice.module.installer.bundle.listener.ApplicationStartupListener;
import ru.vyarus.dropwizard.guice.module.installer.bundle.listener.ApplicationStartupListenerAdapter;
import ru.vyarus.dropwizard.guice.module.installer.bundle.listener.GuiceyStartupListener;
import ru.vyarus.dropwizard.guice.module.installer.bundle.listener.GuiceyStartupListenerAdapter;
import ru.vyarus.dropwizard.guice.module.jersey.debug.HK2DebugBundle;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleListener;

public final class GuiceBundle
implements ConfiguredBundle<Configuration> {
    private final ConfigurationContext context = new ConfigurationContext();
    private InjectorFactory injectorFactory = new DefaultInjectorFactory();
    private GuiceyBundleLookup bundleLookup = new DefaultBundleLookup();

    GuiceBundle() {
        this.context.stat().timer(Stat.GuiceyTime);
        this.context.stat().timer(Stat.ConfigurationTime);
        this.context.stat().timer(Stat.BundleBuilderTime);
    }

    public void initialize(Bootstrap bootstrap) {
        GuiceyInitializer starter = new GuiceyInitializer(bootstrap, this.context);
        starter.initializeBundles(this.bundleLookup);
        starter.findCommands();
        starter.resolveInstallers();
        starter.scanExtensions();
        starter.initFinished();
    }

    public void run(Configuration configuration, Environment environment) throws Exception {
        GuiceyRunner runner = new GuiceyRunner(this.context, configuration, environment);
        runner.runBundles();
        runner.registerExtensions();
        runner.prepareModules();
        runner.createInjector(this.injectorFactory, runner.analyzeAndRepackageBindings());
        runner.installExtensions();
        runner.injectCommands();
        runner.runFinished();
    }

    public Injector getInjector() {
        return this.context.getSharedState().getOrFail(Injector.class, "Guice not initialized", new Object[0]);
    }

    public static Builder builder() {
        return new Builder().hookAlias("diagnostic", DiagnosticHook.class).hookAlias("startup-time", StartupTimeHook.class).hookAlias("provision-time", GuiceProvisionTimeHook.class);
    }

    public static class Builder {
        private final GuiceBundle bundle = new GuiceBundle();
        private boolean buildCalled;

        public <K extends Enum<? extends Option>> Builder option(K option, Object value) {
            this.bundle.context.setOption(option, value);
            return this;
        }

        public <K extends Enum> Builder options(Map<Enum, Object> options) {
            options.forEach((x$0, x$1) -> this.option((Enum)x$0, x$1));
            return this;
        }

        public Builder injectorFactory(InjectorFactory injectorFactory) {
            this.bundle.injectorFactory = injectorFactory;
            return this;
        }

        public Builder bundleLookup(GuiceyBundleLookup bundleLookup) {
            this.bundle.bundleLookup = bundleLookup;
            return this;
        }

        public Builder disableBundleLookup() {
            return this.bundleLookup(new VoidBundleLookup());
        }

        public Builder enableAutoConfig(String ... basePackages) {
            String[] stringArray;
            if (basePackages.length > 0) {
                stringArray = basePackages;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "<app>";
            }
            String[] packs = stringArray;
            return this.option(GuiceyOptions.ScanPackages, packs);
        }

        public Builder autoConfigFilter(Predicate<Class<?>> filter) {
            this.bundle.context.addAutoScanFilter(filter);
            return this;
        }

        public Builder duplicateConfigDetector(DuplicateConfigDetector detector) {
            this.bundle.context.setDuplicatesDetector(detector);
            return this;
        }

        public Builder uniqueItems(Class<?> ... configurationItems) {
            return this.duplicateConfigDetector(new UniqueItemsDuplicatesDetector(configurationItems));
        }

        public Builder modules(Module ... modules) {
            Preconditions.checkState((modules.length > 0 ? 1 : 0) != 0, (Object)"Specify at least one module");
            this.bundle.context.registerModules(modules);
            return this;
        }

        public Builder modulesOverride(Module ... modules) {
            this.bundle.context.registerModulesOverride(modules);
            return this;
        }

        public Builder searchCommands() {
            return this.option(GuiceyOptions.SearchCommands, true);
        }

        public Builder noDefaultInstallers() {
            return this.option(GuiceyOptions.UseCoreInstallers, false);
        }

        public Builder noGuiceFilter() {
            return this.option(GuiceyOptions.GuiceFilterRegistration, EnumSet.noneOf(DispatcherType.class));
        }

        @SafeVarargs
        public final Builder installers(Class<? extends FeatureInstaller> ... installers) {
            this.bundle.context.registerInstallers(installers);
            return this;
        }

        public Builder extensions(Class<?> ... extensionClasses) {
            this.bundle.context.registerExtensions(extensionClasses);
            return this;
        }

        public Builder extensionsOptional(Class<?> ... extensionClasses) {
            this.bundle.context.registerExtensionsOptional(extensionClasses);
            return this;
        }

        public Builder bundles(GuiceyBundle ... bundles) {
            this.bundle.context.registerBundles(bundles);
            return this;
        }

        public Builder dropwizardBundles(ConfiguredBundle ... bundles) {
            this.bundle.context.registerDropwizardBundles(bundles);
            return this;
        }

        @SafeVarargs
        public final Builder disableInstallers(Class<? extends FeatureInstaller> ... installers) {
            this.bundle.context.disableInstallers(installers);
            return this;
        }

        public final Builder disableExtensions(Class<?> ... extensions) {
            this.bundle.context.disableExtensions(extensions);
            return this;
        }

        @SafeVarargs
        public final Builder disableModules(Class<? extends Module> ... modules) {
            this.bundle.context.disableModules(modules);
            return this;
        }

        @SafeVarargs
        public final Builder disableBundles(Class<? extends GuiceyBundle> ... bundles) {
            this.bundle.context.disableBundle(bundles);
            return this;
        }

        @SafeVarargs
        public final Builder disableDropwizardBundles(Class<? extends ConfiguredBundle> ... bundles) {
            this.bundle.context.disableDropwizardBundle(bundles);
            return this;
        }

        @SafeVarargs
        public final Builder disable(Predicate<? extends ItemInfo> ... predicates) {
            this.bundle.context.registerDisablePredicates(predicates);
            return this;
        }

        public Builder listen(GuiceyLifecycleListener ... listeners) {
            this.bundle.context.lifecycle().register(listeners);
            return this;
        }

        public Builder strictScopeControl() {
            this.bundle.context.registerBundles(new HK2DebugBundle());
            return this;
        }

        public Builder useHK2ForJerseyExtensions() {
            this.option(InstallersOptions.JerseyExtensionsManagedByGuice, false);
            this.option(GuiceyOptions.UseHkBridge, true);
            return this;
        }

        public Builder printDiagnosticInfo() {
            return this.listen(new ConfigurationDiagnostic());
        }

        public Builder printExtensionsHelp() {
            return this.listen(new ExtensionsHelpDiagnostic());
        }

        public Builder printAvailableInstallers() {
            return this.listen(ConfigurationDiagnostic.builder("Available installers report").printConfiguration(new DiagnosticConfig().printInstallers().printNotUsedInstallers().printInstallerInterfaceMarkers()).printContextTree(new ContextTreeConfig().hideCommands().hideDuplicateRegistrations().hideEmptyBundles().hideExtensions().hideModules()).build());
        }

        public Builder printConfigurationBindings() {
            return this.listen(new YamlBindingsDiagnostic());
        }

        public Builder printCustomConfigurationBindings() {
            return this.listen(new YamlBindingsDiagnostic(new BindingsConfig().showConfigurationTree().showNullValues().showCustomConfigOnly()));
        }

        public Builder printGuiceBindings() {
            return this.listen(new GuiceBindingsDiagnostic(new GuiceConfig().hideGuiceBindings().hideGuiceyBindings()));
        }

        public Builder printAllGuiceBindings() {
            return this.listen(new GuiceBindingsDiagnostic(new GuiceConfig()));
        }

        public Builder printGuiceAopMap() {
            return this.printGuiceAopMap(new GuiceAopConfig());
        }

        public Builder printGuiceAopMap(GuiceAopConfig config) {
            return this.listen(new GuiceAopDiagnostic(config));
        }

        public Builder printGuiceProvisionTime() {
            return this.bundles(new GuiceProvisionDiagnostic(true));
        }

        public Builder printLifecyclePhases() {
            return this.listen(new LifecycleDiagnostic(false));
        }

        public Builder printLifecyclePhasesDetailed() {
            return this.listen(new LifecycleDiagnostic(true));
        }

        public Builder printWebMappings() {
            return this.listen(new WebMappingsDiagnostic(new MappingsConfig().showMainContext().showAdminContext().showDropwizardMappings().showGuiceMappings()));
        }

        public Builder printJerseyConfig() {
            return this.listen(new JerseyConfigDiagnostic());
        }

        public Builder printStartupTime() {
            return this.listen(new StartupTimeDiagnostic());
        }

        public Builder printSharedStateUsage() {
            return this.listen(new SharedStateDiagnostic());
        }

        public Builder hookAlias(String name, Class<? extends GuiceyConfigurationHook> hook) {
            ConfigurationHooksSupport.registerSystemHookAlias(name, hook);
            return this;
        }

        public Builder whenConfigurationReady(Consumer<GuiceyEnvironment> runPhaseAction) {
            this.bundle.context.addDelayedConfiguration(runPhaseAction);
            return this;
        }

        public Builder withSharedState(Consumer<SharedConfigurationState> stateAction) {
            stateAction.accept(this.bundle.context.getSharedState());
            return this;
        }

        public <C extends Configuration> Builder onGuiceyStartup(GuiceyStartupListener<C> listener) {
            return this.listen(new GuiceyStartupListenerAdapter<C>(listener));
        }

        public Builder onApplicationStartup(ApplicationStartupListener listener) {
            return this.listen(new ApplicationStartupListenerAdapter(listener));
        }

        public Builder onApplicationShutdown(ApplicationShutdownListener listener) {
            return this.listen(new ApplicationShutdownListenerAdapter(listener));
        }

        public Builder listenServer(ServerLifecycleListener listener) {
            this.withEnvironment(environment -> environment.lifecycle().addServerLifecycleListener(listener));
            return this;
        }

        public Builder listenJetty(LifeCycle.Listener listener) {
            this.withEnvironment(environment -> environment.lifecycle().addEventListener(listener));
            return this;
        }

        public Builder listenJersey(ApplicationEventListener listener) {
            this.withEnvironment(environment -> environment.jersey().register((Object)listener));
            return this;
        }

        public GuiceBundle build(Stage stage) {
            this.option(GuiceyOptions.InjectorStage, stage);
            return this.build();
        }

        public GuiceBundle build() {
            Preconditions.checkState((!this.buildCalled ? 1 : 0) != 0, (Object)(".build() was already called for guice bundle. Most likely, it was called second time in " + GuiceyConfigurationHook.class.getSimpleName()));
            this.buildCalled = true;
            this.bundle.context.runHooks(this);
            this.bundle.context.stat().stopTimer(Stat.BundleBuilderTime);
            return this.bundle;
        }

        private void withEnvironment(Consumer<Environment> action) {
            this.onGuiceyStartup((config, env, injector) -> action.accept(env));
        }
    }
}

