/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.start;

import com.google.common.base.MoreObjects;
import java.time.Duration;
import java.util.Map;
import ru.vyarus.dropwizard.guice.GuiceBundle;
import ru.vyarus.dropwizard.guice.debug.report.start.StartupTimeInfo;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.context.stat.DetailStat;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.test.util.PrintUtils;

public class StartupTimeRenderer {
    public String render(StartupTimeInfo info) {
        StringBuilder res = new StringBuilder(200);
        res.append("\n\n").append(this.line(1, "JVM time before", Duration.ofMillis(info.getJvmStart()))).append('\n').append(this.line(1, "Application startup", info.getStats().duration(Stat.OverallTime))).append(this.line(2, "Dropwizard initialization", info.getInitTime()));
        info.getBundlesInitPoints().forEach((s, point) -> {
            if (GuiceBundle.class.equals(s)) {
                this.printGuiceyInit(3, (Duration)point, info, res);
            } else {
                res.append(this.line(3, RenderUtils.getClassName(s), "finished since start at ", (Duration)point, null));
            }
        });
        res.append('\n').append(this.line(2, "Dropwizard run", info.getRunPoint().minus(info.getInitTime()))).append(this.line(3, "Configuration and Environment", info.getDwPreRunTime()));
        info.getBundlesRunTimes().forEach((s, duration) -> {
            if (GuiceBundle.class.equals(s)) {
                this.printGuiceyRun(3, (Duration)duration, info, res);
            } else {
                res.append(this.line(3, RenderUtils.getClassName(s), (Duration)duration));
            }
        });
        res.append('\n').append(this.line(2, "Web server startup", info.getWebTime()));
        this.printGuiceyWeb(3, info, res);
        return res.toString();
    }

    private void printGuiceyInit(int shift, Duration point, StartupTimeInfo info, StringBuilder res) {
        res.append(this.line(shift, GuiceBundle.class.getSimpleName(), null, info.getStats().duration(Stat.ConfigurationTime).minus(info.getStats().duration(Stat.DropwizardBundleInitTime)), " (finished since start at " + PrintUtils.ms(point) + ")")).append(this.line(shift + 1, "Bundle builder time", info.getStats().duration(Stat.BundleBuilderTime))).append(this.line(shift + 1, "Hooks processing", info.getStats().duration(Stat.HooksTime)));
        info.getStats().getDetailedStats(DetailStat.Hook).forEach((type, duration) -> {
            String className = RenderUtils.getClassName(type);
            res.append(this.line(shift + 2, className, (Duration)duration));
        });
        res.append(this.line(shift + 1, "Classpath scan", info.getStats().duration(Stat.ScanTime))).append(this.line(shift + 1, "Commands processing", info.getStats().duration(Stat.CommandTime)));
        info.getStats().getDetailedStats(DetailStat.Command).forEach((type, duration) -> res.append(this.line(shift + 2, RenderUtils.getClassName(type), (Duration)duration)));
        res.append(this.line(shift + 1, "Bundles lookup", info.getStats().duration(Stat.BundleResolutionTime))).append(this.line(shift + 1, "Guicey bundles init", info.getStats().duration(Stat.GuiceyBundleInitTime)));
        Map<Class<?>, Duration> detailedStats = info.getStats().getDetailedStats(DetailStat.BundleInit);
        info.getGuiceyBundlesInitOrder().forEach(type -> {
            Duration actual = (Duration)detailedStats.get(type);
            for (Class transitive : info.getGuiceyBundleTransitives().get(type)) {
                actual = actual.minus((Duration)detailedStats.get(transitive));
            }
            res.append(this.line(shift + 2, RenderUtils.getClassName(type), actual));
        });
        res.append(this.line(shift + 1, "Installers time", info.getInitInstallersTime())).append(this.line(shift + 2, "Installers resolution", info.getStats().duration(Stat.InstallersResolutionTime))).append(this.line(shift + 2, "Scanned extensions recognition", info.getInitExtensionsTime())).append(this.line(shift + 1, "Listeners time", info.getInitListenersTime()));
        info.getStats().getDetailedStats(DetailStat.Listener).forEach((type, time) -> {
            if (info.getInitEvents().contains(type)) {
                res.append(this.line(shift + 2, type.getSimpleName(), (Duration)time));
            }
        });
    }

    private void printGuiceyRun(int shift, Duration duration, StartupTimeInfo info, StringBuilder res) {
        res.append(this.line(shift, GuiceBundle.class.getSimpleName(), duration)).append(this.line(shift + 1, "Configuration analysis", info.getStats().duration(Stat.ConfigurationAnalysis))).append(this.line(shift + 1, "Guicey bundles run", info.getStats().duration(Stat.GuiceyBundleRunTime)));
        info.getStats().getDetailedStats(DetailStat.BundleRun).forEach((type, time) -> res.append(this.line(shift + 2, RenderUtils.getClassName(type), (Duration)time)));
        Duration bindingsAnalysisTime = info.getStats().duration(Stat.BindingsAnalysisTime);
        res.append(this.line(shift + 1, "Guice modules processing", info.getStats().duration(Stat.ModulesProcessingTime))).append(this.line(shift + 2, "Bindings resolution", info.getStats().duration(Stat.BindingsResolutionTime))).append(this.line(shift + 1, "Installers time", info.getStats().duration(Stat.InstallersTime).minus(info.getInitInstallersTime()).plus(info.getStats().duration(Stat.ExtensionsInstallationTime)))).append(this.line(shift + 2, "Extensions registration", info.getStats().duration(Stat.ExtensionsRecognitionTime).minus(info.getInitExtensionsTime()).minus(bindingsAnalysisTime))).append(this.line(shift + 2, "Guice bindings analysis", bindingsAnalysisTime)).append(this.line(shift + 2, "Extensions installation", info.getStats().duration(Stat.ExtensionsInstallationTime))).append(this.line(shift + 1, "Injector creation", info.getStats().duration(Stat.InjectorCreationTime)));
        info.getStats().getGuiceStats().forEach(s -> {
            if (!s.endsWith(" 0 ms")) {
                String[] val = s.split(": ");
                res.append(this.tab(shift + 2)).append(String.format("%-35s: %s%n", val[0], val[1]));
            }
        });
        res.append(this.line(shift + 1, "Listeners time", info.getRunListenersTime()));
        info.getStats().getDetailedStats(DetailStat.Listener).forEach((type, time) -> {
            if (info.getRunEvents().contains(type)) {
                res.append(this.line(shift + 2, type.getSimpleName(), (Duration)time));
            }
        });
    }

    private void printGuiceyWeb(int shift, StartupTimeInfo info, StringBuilder res) {
        int prefix;
        boolean lifecycleSimulation = info.getJerseyTime() == null;
        res.append(this.line(shift, lifecycleSimulation ? "Lifecycle simulation time" : "Jetty lifecycle time", info.getLifecycleTime()));
        info.getManagedTimes().forEach((type, duration) -> res.append(this.tab(shift + 1)).append(String.format("%-10s", info.getManagedTypes().get(type))).append(this.line(0, RenderUtils.getClassName(type), (Duration)duration)));
        int n = prefix = lifecycleSimulation ? shift : shift + 1;
        if (!lifecycleSimulation) {
            res.append(this.line(prefix, "Jersey time", info.getJerseyTime()));
        }
        Duration listenersTime = info.getStats().duration(Stat.ListenersTime).minus(info.getRunListenersTime()).minus(info.getInitListenersTime());
        res.append(this.line(prefix + 1, "Guicey time", info.getStats().duration(Stat.JerseyTime).plus(listenersTime))).append(this.line(prefix + 2, "Installers time", info.getStats().duration(Stat.JerseyInstallerTime))).append(this.line(prefix + 2, "Listeners time", listenersTime));
        info.getStats().getDetailedStats(DetailStat.Listener).forEach((type, time) -> {
            if (info.getWebEvents().contains(type)) {
                res.append(this.line(prefix + 3, type.getSimpleName(), (Duration)time));
            }
        });
    }

    private String line(int shift, String name, Duration duration) {
        return this.line(shift, name, null, duration, null);
    }

    private String line(int shift, String name, String prefix, Duration duration, String postfix) {
        return this.tab(shift) + this.format(name, prefix, duration, postfix);
    }

    private String format(String name, String prefix, Duration duration, String postfix) {
        return String.format("%-35s: %s%s%s%n", name, MoreObjects.firstNonNull((Object)prefix, (Object)""), PrintUtils.ms(duration), MoreObjects.firstNonNull((Object)postfix, (Object)""));
    }

    private String tab(int shift) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < shift; ++i) {
            res.append('\t');
        }
        return res.toString();
    }
}

