/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.stat;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import ru.vyarus.dropwizard.guice.debug.report.ReportRenderer;
import ru.vyarus.dropwizard.guice.debug.util.TreeNode;
import ru.vyarus.dropwizard.guice.module.GuiceyConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.Filters;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.installer.install.JerseyInstaller;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"})
public class StatsRenderer
implements ReportRenderer<Boolean> {
    private final GuiceyConfigurationInfo info;

    public StatsRenderer(GuiceyConfigurationInfo info) {
        this.info = info;
    }

    @Override
    public String renderReport(Boolean hideTiny) {
        TreeNode root = new TreeNode("GUICEY started in %s (%s config / %s run / %s jersey)", this.info.getStats().humanTime(Stat.GuiceyTime), this.info.getStats().humanTime(Stat.ConfigurationTime), this.info.getStats().humanTime(Stat.RunTime), this.info.getStats().humanTime(Stat.JerseyTime));
        this.renderTimes(root, hideTiny);
        StringBuilder res = new StringBuilder().append(Reporter.NEWLINE).append(Reporter.NEWLINE);
        root.render(res);
        return res.toString();
    }

    private void renderTimes(TreeNode root, boolean hideTiny) {
        long remaining = this.info.getStats().time(Stat.GuiceyTime);
        double percent = (double)remaining / 100.0;
        remaining -= this.renderClasspathScanInfo(root, hideTiny, percent);
        remaining -= this.renderBundlesProcessing(root, hideTiny, percent);
        remaining -= this.renderCommandsRegistration(root, hideTiny, percent);
        remaining -= this.renderModulesProcessing(root, percent);
        remaining -= this.renderInstallersProcessing(root, hideTiny, percent);
        remaining -= this.renderInjectorCreation(root, hideTiny, percent);
        remaining -= this.renderExtensionsInstallation(root, hideTiny, percent);
        if (this.show(hideTiny, remaining -= this.renderJerseyPart(root, hideTiny, percent))) {
            root.child("[%.2g%%] remaining %s ms", (double)remaining / percent, remaining);
        }
    }

    private long renderClasspathScanInfo(TreeNode root, boolean hideTiny, double percent) {
        long scan = this.info.getStats().time(Stat.ScanTime);
        if (this.show(hideTiny, scan)) {
            TreeNode node = root.child("[%.2g%%] CLASSPATH scanned in %s", (double)scan / percent, this.info.getStats().humanTime(Stat.ScanTime));
            int classes = this.info.getStats().count(Stat.ScanClassesCount);
            node.child("scanned %s classes", classes);
            int recognized = this.info.getData().getItems(Filters.fromScan()).size();
            node.child("recognized %s classes (%.2g%% of scanned)", recognized, Float.valueOf((float)recognized / ((float)classes / 100.0f)));
        }
        return scan;
    }

    private long renderBundlesProcessing(TreeNode root, boolean hideTiny, double percent) {
        long bundle = this.info.getStats().time(Stat.BundleTime);
        if (this.show(hideTiny, bundle)) {
            int dwBundles;
            int guiceyBundles;
            TreeNode node = root.child("[%.2g%%] BUNDLES processed in %s", (double)bundle / percent, this.info.getStats().humanTime(Stat.BundleTime));
            long resolved = this.info.getStats().time(Stat.BundleResolutionTime);
            if (this.show(hideTiny, resolved)) {
                node.child("%s resolved in %s", this.info.getBundlesFromLookup().size(), this.info.getStats().humanTime(Stat.BundleResolutionTime));
            }
            if ((guiceyBundles = this.info.getGuiceyBundles().size()) > 0) {
                node.child("%s initialized in %s", guiceyBundles, this.info.getStats().humanTime(Stat.GuiceyBundleInitTime));
            }
            if ((dwBundles = this.info.getDropwizardBundles().size()) > 0) {
                node.child("%s dropwizard bundles initialized in %s", dwBundles, this.info.getStats().humanTime(Stat.DropwizardBundleInitTime));
            }
        }
        return bundle;
    }

    private long renderCommandsRegistration(TreeNode root, boolean hideTiny, double percent) {
        long command = this.info.getStats().time(Stat.CommandTime);
        if (this.show(hideTiny, command)) {
            TreeNode node = root.child("[%.2g%%] COMMANDS processed in %s", (double)command / percent, this.info.getStats().humanTime(Stat.CommandTime));
            int registered = this.info.getCommands().size();
            if (registered > 0) {
                node.child("registered %s commands", registered);
            }
        }
        return command;
    }

    private long renderModulesProcessing(TreeNode root, double percent) {
        long modules = this.info.getStats().time(Stat.ModulesProcessingTime);
        TreeNode node = root.child("[%.2g%%] MODULES processed in %s", (double)modules / percent, this.info.getStats().humanTime(Stat.ModulesProcessingTime));
        node.child("%s modules autowired", this.info.getModules().size());
        int bindings = this.info.getStats().count(Stat.AnalyzedBindingsCount);
        if (bindings > 0) {
            int removedModules;
            node.child("%s elements found in %s user modules in %s", this.info.getStats().count(Stat.BindingsCount), this.info.getNormalModules().size() - 1, this.info.getStats().humanTime(Stat.BindingsResolutionTime));
            int found = this.info.getData().getItems(ConfigItem.Extension, Filters.fromBinding()).size();
            node.child("%s extensions detected from %s acceptable bindings", found, bindings);
            int removed = this.info.getStats().count(Stat.RemovedBindingsCount);
            if (removed > 0) {
                node.child("%s elements removed", removed);
            }
            if ((removedModules = this.info.getStats().count(Stat.RemovedInnerModules)) > 0) {
                node.child("%s inner modules removed (types)", removedModules);
            }
        }
        return modules;
    }

    private long renderInstallersProcessing(TreeNode root, boolean hideTiny, double percent) {
        long installers = this.info.getStats().time(Stat.InstallersTime);
        if (this.show(hideTiny, installers)) {
            TreeNode node = root.child("[%.2g%%] INSTALLERS processed in %s", (double)installers / percent, this.info.getStats().humanTime(Stat.InstallersTime));
            int registered = this.info.getInstallers().size();
            if (registered > 0) {
                node.child("registered %s installers", registered);
                long extensions = this.info.getStats().time(Stat.ExtensionsRecognitionTime);
                if (this.show(hideTiny, extensions)) {
                    int manual = this.info.getExtensionsRegisteredManauallyOnly().size();
                    node.child("%s extensions recognized from %s classes in %s", this.info.getData().getItems(ConfigItem.Extension).size(), this.info.getStats().count(Stat.ScanClassesCount) + this.info.getStats().count(Stat.AnalyzedBindingsCount) + manual, this.info.getStats().humanTime(Stat.ExtensionsRecognitionTime));
                }
            }
        }
        return installers;
    }

    private long renderInjectorCreation(TreeNode root, boolean hideTiny, double percent) {
        long injector = this.info.getStats().time(Stat.InjectorCreationTime);
        TreeNode node = root.child("[%.2g%%] INJECTOR created in %s", (double)injector / percent, this.info.getStats().humanTime(Stat.InjectorCreationTime));
        this.info.getStats().getGuiceStats().forEach(it -> {
            if (!hideTiny || !it.endsWith(" 0 ms")) {
                node.child((String)it, new Object[0]);
            }
        });
        return injector;
    }

    private long renderExtensionsInstallation(TreeNode root, boolean hideTiny, double percent) {
        long extensions = this.info.getStats().time(Stat.ExtensionsInstallationTime);
        if (this.show(hideTiny, extensions)) {
            TreeNode node = root.child("[%.2g%%] EXTENSIONS installed in %s", (double)extensions / percent, this.info.getStats().humanTime(Stat.ExtensionsInstallationTime));
            node.child("%s extensions installed", this.info.getExtensions().size());
            node.child("declared as: %s manual, %s scan, %s binding", this.info.getExtensionsRegisteredManually().size(), this.info.getExtensionsFromScan().size(), this.info.getExtensionsFromBindings().size());
        }
        return extensions;
    }

    private long renderJerseyPart(TreeNode root, boolean hideTiny, double percent) {
        long hk = this.info.getStats().time(Stat.JerseyTime);
        if (this.show(hideTiny, hk)) {
            TreeNode node = root.child("[%.2g%%] JERSEY bridged in %s", (double)hk / percent, this.info.getStats().humanTime(Stat.JerseyTime));
            int installers = this.info.getData().getItems(ConfigItem.Installer, it -> JerseyInstaller.class.isAssignableFrom(it.getType())).size();
            if (installers > 0) {
                node.child("using %s jersey installers", installers);
                int extensions = this.info.getData().getItems(ConfigItem.Extension, it -> it.isEnabled() && JerseyInstaller.class.isAssignableFrom(it.getInstalledBy())).size();
                node.child("%s jersey extensions installed in %s", extensions, this.info.getStats().humanTime(Stat.JerseyInstallerTime));
            }
        }
        return hk;
    }

    private boolean show(boolean hideTiny, long value) {
        return !hideTiny || value > 0L;
    }
}

