/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.web;

import com.google.common.base.Throwables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Binding;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.servlet.UriPatternType;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.jetty.MutableServletContextHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import ru.vyarus.dropwizard.guice.debug.report.ReportRenderer;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.GuiceModelUtils;
import ru.vyarus.dropwizard.guice.debug.report.web.MappingsConfig;
import ru.vyarus.dropwizard.guice.debug.report.web.model.WebElementModel;
import ru.vyarus.dropwizard.guice.debug.report.web.model.WebElementType;
import ru.vyarus.dropwizard.guice.debug.report.web.util.ServletVisitor;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.debug.util.TreeNode;
import ru.vyarus.dropwizard.guice.module.GuiceyConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.info.ModuleItemInfo;
import ru.vyarus.dropwizard.guice.module.installer.util.BindingUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

public class WebMappingsRenderer
implements ReportRenderer<MappingsConfig> {
    private static final ServletVisitor VISITOR = new ServletVisitor();
    private static final String STOPPED = "STOPPED";
    private static final String ASYNC = "async";
    private static final String IDEM = "--\"--";
    private final Environment environment;
    private final List<Module> modules;

    public WebMappingsRenderer(Environment environment, GuiceyConfigurationInfo info) {
        this.environment = environment;
        this.modules = info.getModuleIds().stream().map(it -> (Module)((ModuleItemInfo)info.getData().getInfo((ItemId)it)).getInstance()).collect(Collectors.toList());
    }

    @Override
    public String renderReport(MappingsConfig config) {
        StringBuilder res = new StringBuilder();
        if (config.isMainContext()) {
            this.renderContext(config, this.environment.getApplicationContext(), "MAIN", res);
        }
        if (config.isAdminContext()) {
            this.renderContext(config, this.environment.getAdminContext(), "ADMIN", res);
        }
        return res.toString();
    }

    private void renderContext(MappingsConfig config, MutableServletContextHandler handler, String name, StringBuilder res) {
        TreeNode root = new TreeNode("%s %s", name, handler.getContextPath());
        try {
            Multimap<String, FilterReference> servletFilters = this.renderContextFilters(config, handler, root);
            if (handler.getServletHandler().getServletMappings() != null) {
                for (ServletMapping mapping : handler.getServletHandler().getServletMappings()) {
                    ServletHolder servlet = handler.getServletHandler().getServlet(mapping.getServletName());
                    if (!this.isAllowed(servlet.getClassName(), config)) continue;
                    this.renderServlet(mapping, servlet, servletFilters, root);
                }
            }
        }
        catch (Exception ex) {
            Throwables.throwIfUnchecked((Throwable)ex);
            throw new IllegalStateException(ex);
        }
        if (root.hasChildren()) {
            res.append(Reporter.NEWLINE).append(Reporter.NEWLINE);
            root.render(res);
        }
    }

    private Multimap<String, FilterReference> renderContextFilters(MappingsConfig config, MutableServletContextHandler handler, TreeNode root) throws Exception {
        LinkedHashMultimap servletFilters = LinkedHashMultimap.create();
        for (FilterMapping mapping : handler.getServletHandler().getFilterMappings()) {
            FilterHolder holder = handler.getServletHandler().getFilter(mapping.getFilterName());
            boolean isGuiceFilter = "Guice Filter".equals(mapping.getFilterName());
            if (isGuiceFilter && !config.isGuiceMappings() || !this.isAllowed(holder.getClassName(), config)) continue;
            if (mapping.getServletNames() != null && mapping.getServletNames().length > 0) {
                for (String servlet : mapping.getServletNames()) {
                    servletFilters.put((Object)servlet, (Object)new FilterReference(mapping, holder));
                }
                continue;
            }
            TreeNode filter = this.renderFilter(mapping, holder, root);
            if (!isGuiceFilter) continue;
            this.renderGuiceWeb(filter);
        }
        return servletFilters;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"})
    private void renderServlet(ServletMapping mapping, ServletHolder holder, Multimap<String, FilterReference> servletFilters, TreeNode root) throws Exception {
        ArrayList<String> markers = new ArrayList<String>();
        boolean first = true;
        for (String path : mapping.getPathSpecs()) {
            markers.clear();
            if (first && !holder.isEnabled()) {
                markers.add("DISABLED");
            }
            String type = IDEM;
            String async = "";
            String stopped = "";
            String name = "";
            if (first) {
                type = RenderUtils.renderClassLine(Class.forName(holder.getClassName()), markers);
                if (holder.isStopped()) {
                    stopped = STOPPED;
                }
                if (holder.isAsyncSupported()) {
                    async = ASYNC;
                }
                name = mapping.getServletName();
            }
            TreeNode servlet = root.child("servlet    %-20s %-7s %-70s %-10s    %-15s %s", path, async, type, stopped, "", name);
            if (first) {
                for (FilterReference filter : servletFilters.get((Object)mapping.getServletName())) {
                    this.renderFilter(filter.getMapping(), filter.getHolder(), servlet);
                }
            }
            first = false;
        }
    }

    private TreeNode renderFilter(FilterMapping mapping, FilterHolder holder, TreeNode root) throws Exception {
        TreeNode last = null;
        boolean first = true;
        boolean servletMapping = mapping.getPathSpecs() == null || mapping.getPathSpecs().length == 0;
        for (String path : servletMapping ? mapping.getServletNames() : mapping.getPathSpecs()) {
            String type = IDEM;
            String async = "";
            String stopped = "";
            String dispatches = "";
            String name = "";
            if (first) {
                type = RenderUtils.renderClassLine(Class.forName(holder.getClassName()));
                if (holder.isStopped()) {
                    stopped = STOPPED;
                }
                if (holder.isAsyncSupported()) {
                    async = ASYNC;
                }
                dispatches = mapping.getDispatcherTypes().toString();
                name = mapping.getFilterName();
            }
            last = root.child("filter     %-20s %-7s %-70s %-10s    %-15s %s", servletMapping ? "" : path, async, type, stopped, dispatches, name);
            first = false;
        }
        return last;
    }

    private void renderGuiceWeb(TreeNode filter) throws Exception {
        ArrayList<String> servlets = new ArrayList<String>();
        ArrayList<String> filters = new ArrayList<String>();
        for (Element element : Elements.getElements((Stage)Stage.TOOL, this.modules)) {
            WebElementModel model;
            if (!(element instanceof Binding) || (model = (WebElementModel)((Binding)element).acceptTargetVisitor((BindingTargetVisitor)VISITOR)) == null) continue;
            String line = this.renderGuiceWebElement(model, element);
            if (model.getType().equals((Object)WebElementType.FILTER)) {
                filters.add(line);
                continue;
            }
            servlets.add(line);
        }
        this.renderGucieWebElements(servlets, filters, filter);
    }

    private String renderGuiceWebElement(WebElementModel model, Element element) throws Exception {
        return String.format("%-15s %-20s %-7s %-30s %s", model.getType().equals((Object)WebElementType.FILTER) ? "guicefilter" : "guiceservlet", model.getPattern(), model.getPatternType() == UriPatternType.REGEX ? "regex" : "", (model.isInstance() ? "instance of " : "") + GuiceModelUtils.renderKey(model.getKey()), RenderUtils.renderClass(Class.forName(BindingUtils.getModules(element).get(0))));
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"})
    private void renderGucieWebElements(List<String> servlets, List<String> filters, TreeNode root) {
        if (servlets.isEmpty() && filters.isEmpty()) {
            return;
        }
        if (!filters.isEmpty()) {
            for (String line : filters) {
                root.child(line, new Object[0]);
            }
        }
        if (!servlets.isEmpty()) {
            for (String line : servlets) {
                root.child(line, new Object[0]);
            }
        }
    }

    private boolean isAllowed(String type, MappingsConfig config) {
        return config.isDropwizardMappings() || !type.startsWith("org.eclipse.jetty") && !type.startsWith("io.dropwizard") && !type.startsWith("com.codahale.metrics");
    }

    private static class FilterReference {
        private final FilterMapping mapping;
        private final FilterHolder holder;

        FilterReference(FilterMapping mapping, FilterHolder holder) {
            this.mapping = mapping;
            this.holder = holder;
        }

        public FilterMapping getMapping() {
            return this.mapping;
        }

        public FilterHolder getHolder() {
            return this.holder;
        }
    }
}

