/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.util;

public class ClassNameAbbreviator {
    private static final int MAX_DOTS = 16;
    private static final char DOT = '.';
    private final int targetLength;

    public ClassNameAbbreviator(int targetLength) {
        this.targetLength = targetLength;
    }

    public String abbreviate(String fqClassName) {
        String res;
        if (fqClassName == null) {
            throw new IllegalArgumentException("Class name may not be null");
        }
        if (fqClassName.length() < this.targetLength) {
            res = fqClassName;
        } else {
            int[] dotIndexesArray = new int[16];
            int[] lengthArray = new int[17];
            int dotCount = this.computeDotIndexes(fqClassName, dotIndexesArray);
            if (dotCount == 0) {
                res = fqClassName;
            } else {
                this.computeLengthArray(fqClassName, dotIndexesArray, lengthArray, dotCount);
                StringBuilder buf = new StringBuilder(this.targetLength);
                for (int i = 0; i <= dotCount; ++i) {
                    if (i == 0) {
                        buf.append(fqClassName, 0, lengthArray[i] - 1);
                        continue;
                    }
                    buf.append(fqClassName, dotIndexesArray[i - 1], dotIndexesArray[i - 1] + lengthArray[i]);
                }
                res = buf.toString();
            }
        }
        return res;
    }

    private int computeDotIndexes(String className, int ... dotArray) {
        int dotCount;
        int k = 0;
        for (dotCount = 0; (k = className.indexOf(46, k)) != -1 && dotCount < 16; ++dotCount) {
            dotArray[dotCount] = k++;
        }
        return dotCount;
    }

    private void computeLengthArray(String className, int[] dotArray, int[] lengthArray, int dotCount) {
        int toTrim = className.length() - this.targetLength;
        for (int i = 0; i < dotCount; ++i) {
            int previousDotPosition = -1;
            if (i > 0) {
                previousDotPosition = dotArray[i - 1];
            }
            int available = dotArray[i] - previousDotPosition - 1;
            int len = Math.min(available, 1);
            if (toTrim <= 0) {
                len = available;
            }
            toTrim -= available - len;
            lengthArray[i] = len + 1;
        }
        lengthArray[dotCount] = className.length() - dotArray[dotCount - 1];
    }
}

