/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module;

import com.google.inject.Module;
import com.google.inject.Scopes;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import jakarta.inject.Singleton;
import ru.vyarus.dropwizard.guice.module.GuiceyConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.option.Options;
import ru.vyarus.dropwizard.guice.module.context.option.OptionsInfo;
import ru.vyarus.dropwizard.guice.module.context.stat.StatsInfo;
import ru.vyarus.dropwizard.guice.module.installer.InstallerModule;
import ru.vyarus.dropwizard.guice.module.jersey.Jersey2Module;
import ru.vyarus.dropwizard.guice.module.support.DropwizardAwareModule;
import ru.vyarus.dropwizard.guice.module.support.scope.Prototype;
import ru.vyarus.dropwizard.guice.module.yaml.bind.ConfigBindingModule;

public class GuiceBootstrapModule<T extends Configuration>
extends DropwizardAwareModule<T> {
    private final ConfigurationContext context;

    public GuiceBootstrapModule(ConfigurationContext context) {
        this.context = context;
    }

    protected void configure() {
        this.bindScope(Prototype.class, Scopes.NO_SCOPE);
        this.bindEnvironment();
        this.install((Module)new InstallerModule(this.context));
        this.install((Module)new Jersey2Module(this.bootstrap().getApplication(), this.environment(), this.context));
        this.bind(Options.class).toInstance((Object)this.options());
        this.bind(ConfigurationInfo.class).toInstance((Object)new ConfigurationInfo(this.context));
        this.bind(StatsInfo.class).toInstance((Object)new StatsInfo(this.context.stat()));
        this.bind(OptionsInfo.class).toInstance((Object)new OptionsInfo(this.context.options()));
        this.bind(GuiceyConfigurationInfo.class).in(Singleton.class);
    }

    private void bindEnvironment() {
        this.bind(Bootstrap.class).toInstance(this.bootstrap());
        this.bind(Environment.class).toInstance((Object)this.environment());
        this.install((Module)new ConfigBindingModule((Configuration)this.configuration(), this.configurationTree()));
    }
}

