/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import ru.vyarus.dropwizard.guice.GuiceyOptions;
import ru.vyarus.dropwizard.guice.injector.InjectorFactory;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorLookup;
import ru.vyarus.dropwizard.guice.module.GuiceBootstrapModule;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.context.stat.StatTimer;
import ru.vyarus.dropwizard.guice.module.installer.internal.CommandSupport;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsHolder;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsSupport;
import ru.vyarus.dropwizard.guice.module.installer.internal.ModulesSupport;
import ru.vyarus.dropwizard.guice.module.installer.util.BundleSupport;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;

public class GuiceyRunner {
    private final ConfigurationContext context;
    private Injector injector;

    public GuiceyRunner(ConfigurationContext context, Configuration configuration, Environment environment) {
        context.stat().timer(Stat.GuiceyTime);
        context.stat().timer(Stat.RunTime);
        context.runPhaseStarted(configuration, environment);
        this.context = context;
    }

    public void runBundles() throws Exception {
        StatTimer timer = this.context.stat().timer(Stat.BundleTime);
        StatTimer runTimer = this.context.stat().timer(Stat.GuiceyBundleRunTime);
        BundleSupport.runBundles(this.context);
        runTimer.stop();
        timer.stop();
    }

    public void registerExtensions() {
        this.context.stat().timer(Stat.InstallersTime);
        this.context.stat().timer(Stat.ExtensionsRecognitionTime);
        ExtensionsHolder holder = this.context.getExtensionsHolder();
        List<Class<?>> manual = this.context.getEnabledExtensions();
        for (Class<?> type : manual) {
            if (ExtensionsSupport.registerExtension(this.context, type, false)) continue;
            throw new IllegalStateException("No installer found for extension " + type.getName() + ". Available installers: " + holder.getInstallerTypes().stream().map(FeatureUtils::getInstallerExtName).collect(Collectors.joining(", ")));
        }
        this.context.lifecycle().manualExtensionsValidated(this.context.getItems(ConfigItem.Extension), manual);
        if (holder.getScanExtensions() != null) {
            holder.getScanExtensions().forEach(cand -> {
                Class<?> type = cand.getType();
                if (manual.contains(type)) {
                    this.context.getOrRegisterExtension(type, true);
                } else {
                    ExtensionsSupport.registerExtension(this.context, type, cand.getInstaller(), true);
                }
            });
        }
        this.context.stat().stopTimer(Stat.ExtensionsRecognitionTime);
        this.context.stat().stopTimer(Stat.InstallersTime);
    }

    public void prepareModules() {
        StatTimer timer = this.context.stat().timer(Stat.ModulesProcessingTime);
        this.context.registerModules(new Module[]{new GuiceBootstrapModule(this.context)});
        ModulesSupport.configureModules(this.context);
        timer.stop();
    }

    public Iterable<Module> analyzeAndRepackageBindings() {
        Iterable<Module> res = ModulesSupport.prepareModules(this.context);
        this.context.finalizeConfiguration();
        this.context.lifecycle().extensionsResolved(this.context.getEnabledExtensions(), this.context.getDisabledExtensions());
        return res;
    }

    public void createInjector(InjectorFactory injectorFactory, Iterable<Module> modules) {
        StatTimer timer = this.context.stat().timer(Stat.InjectorCreationTime);
        this.context.lifecycle().injectorCreation(new ArrayList<Module>(this.context.getNormalModules()), new ArrayList<Module>(this.context.getOverridingModules()), this.context.getDisabledModules(), this.context.getIgnoredItems(ConfigItem.Module));
        this.context.stat().getGuiceStats().injectLogsInterceptor();
        this.injector = injectorFactory.createInjector((Stage)this.context.option(GuiceyOptions.InjectorStage), modules);
        this.context.stat().getGuiceStats().resetStatsLogger();
        InjectorLookup.registerInjector(this.context.getBootstrap().getApplication(), this.injector);
        timer.stop();
    }

    public void installExtensions() {
        StatTimer timer = this.context.stat().timer(Stat.ExtensionsInstallationTime);
        ExtensionsSupport.installExtensions(this.context, this.injector);
        timer.stop();
    }

    public void injectCommands() {
        StatTimer timer = this.context.stat().timer(Stat.CommandTime);
        CommandSupport.initCommands(this.context.getBootstrap().getCommands(), this.injector, this.context.stat());
        timer.stop();
    }

    public void runFinished() {
        this.context.bundleStarted();
        this.context.stat().stopTimer(Stat.RunTime);
        this.context.stat().stopTimer(Stat.GuiceyTime);
    }
}

