/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Injector;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.lifecycle.Managed;
import jakarta.inject.Provider;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import ru.vyarus.dropwizard.guice.module.context.option.Options;
import ru.vyarus.dropwizard.guice.module.installer.util.StackUtils;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public class SharedConfigurationState {
    public static final String CONTEXT_APPLICATION_PROPERTY = "guicey.context.application";
    private static final Map<Application, SharedConfigurationState> STATE = Maps.newConcurrentMap();
    private static final ThreadLocal<SharedConfigurationState> STARTUP_INSTANCE = new ThreadLocal();
    private final Map<String, Object> state = new LinkedHashMap<String, Object>();
    private final Map<String, String> statePopulationTrack = new LinkedHashMap<String, String>();
    private final Multimap<String, String> stateAccessTrack = LinkedHashMultimap.create();
    private final Map<Consumer, String> listenersTrack = new LinkedHashMap<Consumer, String>();
    private final Multimap<String, Consumer> listeners = LinkedHashMultimap.create();
    private Application application;

    public SharedConfigurationState() {
        STARTUP_INSTANCE.set(this);
    }

    public <V> V get(Class<V> key) {
        return this.get(key.getName());
    }

    public <V> V get(String key) {
        Object v = this.state.get(key);
        this.stateAccessTrack.put((Object)key, (Object)((v == null ? "MISS " : "GET  ") + StackUtils.getSharedStateSource()));
        return (V)v;
    }

    public <V> V get(Class<V> key, Supplier<V> defaultValue) {
        if (!this.state.containsKey(key.getName())) {
            this.put(key, defaultValue.get());
        }
        return this.get(key);
    }

    public <V> V getOrFail(Class<V> key, String message, Object ... args) {
        V res = this.get(key);
        if (res == null) {
            throw new IllegalStateException(Strings.lenientFormat((String)message, (Object[])args));
        }
        return res;
    }

    public <V> void whenReady(Class<V> key, Consumer<V> action) {
        String name = key.getName();
        if (this.state.containsKey(name)) {
            action.accept(this.get(name));
        } else {
            this.listeners.put((Object)name, action);
            this.listenersTrack.put(action, StackUtils.getSharedStateSource());
        }
    }

    public Options getOptions() {
        return (Options)Preconditions.checkNotNull((Object)this.get(Options.class), (Object)"Options object not yet available");
    }

    public <C extends Configuration> Provider<Bootstrap<C>> getBootstrap() {
        return () -> (Bootstrap)Preconditions.checkNotNull((Object)this.get(Bootstrap.class), (Object)"Bootstrap object not yet available");
    }

    public <C extends Configuration> Provider<Application<C>> getApplication() {
        return () -> Optional.ofNullable(this.get(Bootstrap.class)).map(b -> b.getApplication()).orElseThrow(() -> new NullPointerException("Application instance is not yet available"));
    }

    public Provider<Environment> getEnvironment() {
        return () -> (Environment)Preconditions.checkNotNull((Object)this.get(Environment.class), (Object)"Environment is not yet available");
    }

    public <C extends Configuration> Provider<C> getConfiguration() {
        return () -> (Configuration)Preconditions.checkNotNull((Object)this.get(Configuration.class), (Object)"Configuration is not yet available");
    }

    public Provider<ConfigurationTree> getConfigurationTree() {
        return () -> (ConfigurationTree)Preconditions.checkNotNull((Object)this.get(ConfigurationTree.class), (Object)"ConfigurationTree is not yet available");
    }

    public Provider<Injector> getInjector() {
        return () -> (Injector)Preconditions.checkNotNull((Object)this.get(Injector.class), (Object)"Injector is not yet available");
    }

    public <V> void put(Class<V> key, V value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Shared state key can't be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Shared state does not accept null values");
        String name = key.getName();
        Preconditions.checkState((!this.state.containsKey(name) ? 1 : 0) != 0, (String)"Shared state for key %s already defined", (Object)name);
        this.state.put(name, value);
        this.statePopulationTrack.put(name, StackUtils.getSharedStateSource());
        this.listeners.removeAll((Object)name).forEach(consumer -> {
            consumer.accept(value);
            this.stateAccessTrack.put((Object)name, (Object)("GET " + this.listenersTrack.get(consumer)));
        });
    }

    public Set<String> getKeys() {
        return new HashSet<String>(this.state.keySet());
    }

    @VisibleForTesting
    public void shutdown() {
        STATE.remove(this.application);
    }

    public String toString() {
        return "Shared state with " + this.state.size() + " objects: " + String.join((CharSequence)", ", this.getKeys());
    }

    protected void assignTo(Application application) {
        this.application = application;
        Preconditions.checkState((!STATE.containsKey(application) ? 1 : 0) != 0, (String)"Shared state already associated with application %s", (Object)application.getClass().getName());
        STATE.put(application, this);
    }

    protected void listen(Environment environment) {
        environment.getApplicationContext().setAttribute(CONTEXT_APPLICATION_PROPERTY, (Object)this.application);
        environment.lifecycle().manage((Managed)new RegistryShutdown(this));
    }

    protected void forgetStartupInstance() {
        STARTUP_INSTANCE.remove();
    }

    public static SharedConfigurationState getStartupInstance() {
        return (SharedConfigurationState)Preconditions.checkNotNull((Object)STARTUP_INSTANCE.get(), (Object)"Shared state startup instance is not available: either you try to access it from different threador trying to obtain instance after application startup (in later case, use lookup by application or environment objects instead).");
    }

    public static <V> Optional<V> lookup(Application application, Class<V> key) {
        return SharedConfigurationState.get(application).map(value -> value.get(key));
    }

    public static <V> Optional<V> lookup(Environment environment, Class<V> key) {
        return SharedConfigurationState.get(environment).map(value -> value.get(key));
    }

    public static <V> V lookupOrFail(Application application, Class<V> key, String message, Object ... args) {
        return SharedConfigurationState.lookup(application, key).orElseThrow(() -> new IllegalStateException(Strings.lenientFormat((String)message, (Object[])args)));
    }

    public static <V> V lookupOrFail(Environment environment, Class<V> key, String message, Object ... args) {
        return SharedConfigurationState.lookup(environment, key).orElseThrow(() -> new IllegalStateException(Strings.lenientFormat((String)message, (Object[])args)));
    }

    public static Optional<SharedConfigurationState> get(Application application) {
        return Optional.ofNullable(STATE.get(application));
    }

    public static Optional<SharedConfigurationState> get(Environment environment) {
        Application application = (Application)environment.getApplicationContext().getAttribute(CONTEXT_APPLICATION_PROPERTY);
        return application == null ? Optional.empty() : SharedConfigurationState.get(application);
    }

    public static SharedConfigurationState getOrFail(Application application, String message, Object ... args) {
        return SharedConfigurationState.get(application).orElseThrow(() -> new IllegalStateException(Strings.lenientFormat((String)message, (Object[])args)));
    }

    public static SharedConfigurationState getOrFail(Environment environment, String message, Object ... args) {
        return SharedConfigurationState.get(environment).orElseThrow(() -> new IllegalStateException(Strings.lenientFormat((String)message, (Object[])args)));
    }

    @VisibleForTesting
    public static void clear() {
        STATE.clear();
    }

    @VisibleForTesting
    public static int statesCount() {
        return STATE.size();
    }

    public String getAccessReport() {
        StringBuilder report = new StringBuilder(200);
        boolean blankLineAdded = false;
        for (Map.Entry<String, String> entry : this.statePopulationTrack.entrySet()) {
            String k = entry.getKey();
            String value = entry.getValue();
            Collection gets = this.stateAccessTrack.get((Object)k);
            report.append(!blankLineAdded && (report.length() == 0 || !gets.isEmpty()) ? "\n" : "").append("\tSET ").append(String.format("%-80s\t %s%n", this.renderKey(k), value));
            blankLineAdded = false;
            gets.forEach(s -> report.append("\t\t").append((String)s).append('\n'));
            if (gets.isEmpty()) continue;
            report.append('\n');
            blankLineAdded = true;
        }
        LinkedHashSet notset = new LinkedHashSet(this.stateAccessTrack.keySet());
        notset.removeAll(this.statePopulationTrack.keySet());
        notset.forEach(key -> {
            report.append("\n\tNEVER SET ").append(this.renderKey((String)key)).append('\n');
            this.stateAccessTrack.get(key).forEach(s -> report.append("\t\t").append((String)s).append('\n'));
            this.listeners.get(key).forEach(consumer -> report.append("\t\tMISS ").append(this.listenersTrack.get(consumer)).append('\n'));
        });
        this.listeners.keySet().forEach(key -> {
            if (!notset.contains(key)) {
                report.append("\n\tNEVER SET ").append(this.renderKey((String)key)).append('\n');
                this.listeners.get(key).forEach(consumer -> report.append("\t\tMISS ").append(this.listenersTrack.get(consumer)).append('\n'));
            }
        });
        return report.toString();
    }

    private String renderKey(String key) {
        int lastDot = key.lastIndexOf(46);
        return key.substring(lastDot + 1) + " (" + key.substring(0, lastDot) + ")";
    }

    private static class RegistryShutdown
    implements Managed {
        private final SharedConfigurationState state;

        protected RegistryShutdown(SharedConfigurationState state) {
            this.state = state;
        }

        public void stop() throws Exception {
            this.state.shutdown();
        }
    }
}

