/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.jersey.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Stage;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.spi.internal.ValueParamProvider;
import ru.vyarus.dropwizard.guice.module.installer.InstallersOptions;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.AbstractJerseyInstaller;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.provider.ProviderReporter;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.BindingInstaller;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;
import ru.vyarus.dropwizard.guice.module.installer.util.BindingUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.JerseyBinding;
import ru.vyarus.java.generics.resolver.GenericsResolver;

@Order(value=30)
public class JerseyProviderInstaller
extends AbstractJerseyInstaller<Object>
implements BindingInstaller {
    private static final Set<Class<?>> EXTENSION_TYPES = ImmutableSet.of(ExceptionMapper.class, ParamConverterProvider.class, ContextResolver.class, MessageBodyReader.class, MessageBodyWriter.class, ReaderInterceptor.class, (Object[])new Class[]{WriterInterceptor.class, ContainerRequestFilter.class, ContainerResponseFilter.class, DynamicFeature.class, ValueParamProvider.class, InjectionResolver.class, ApplicationEventListener.class, ModelProcessor.class});
    private final ProviderReporter reporter = new ProviderReporter();

    @Override
    public boolean matches(Class<?> type) {
        return FeatureUtils.hasAnnotation(type, Provider.class) || !Modifier.isAbstract(type.getModifiers()) && (Boolean)this.option(InstallersOptions.JerseyExtensionsRecognizedByType) != false && EXTENSION_TYPES.stream().anyMatch(ext -> ext.isAssignableFrom(type));
    }

    @Override
    public void bind(Binder binder, Class<?> type, boolean lazyMarker) {
        boolean hkManaged = this.isJerseyExtension(type);
        boolean lazy = this.isLazy(type, lazyMarker);
        if (!hkManaged && !lazy) {
            this.bindInGuice(binder, type);
        }
    }

    @Override
    public <T> void manualBinding(Binder binder, Class<T> type, Binding<T> binding) {
        boolean hkManaged = this.isJerseyExtension(type);
        Preconditions.checkState((!hkManaged ? 1 : 0) != 0, (String)"Provider annotated as jersey managed is declared manually in guice: %s (%s)", (Object)type.getName(), (Object)BindingUtils.getDeclarationSource(binding));
    }

    @Override
    public void extensionBound(Stage stage, Class<?> type) {
        if (stage != Stage.TOOL) {
            boolean hkManaged = this.isJerseyExtension(type);
            this.reporter.provider(type, hkManaged, false);
        }
    }

    @Override
    public void install(AbstractBinder binder, Injector injector, Class<Object> type) {
        boolean hkExtension = this.isJerseyExtension(type);
        boolean forceSingleton = this.isForceSingleton(type, hkExtension);
        boolean prioritize = (Boolean)this.option(InstallersOptions.PrioritizeJerseyExtensions);
        if (FeatureUtils.is(type, Supplier.class)) {
            JerseyBinding.bindFactory(binder, injector, type, hkExtension, forceSingleton);
        } else {
            Sets.SetView extensions = Sets.intersection(EXTENSION_TYPES, (Set)GenericsResolver.resolve(type, (Class[])new Class[0]).getGenericsInfo().getComposingTypes());
            if (!extensions.isEmpty()) {
                for (Class ext : extensions) {
                    JerseyBinding.bindSpecificComponent(binder, injector, type, ext, hkExtension, forceSingleton, prioritize, ModelProcessor.class.equals((Object)ext));
                }
            } else {
                JerseyBinding.bindComponent(binder, injector, type, hkExtension, forceSingleton);
            }
        }
    }

    @Override
    public void report() {
        this.reporter.report();
    }

    @Override
    public List<String> getRecognizableSigns() {
        ArrayList<String> res = new ArrayList<String>();
        res.add("@" + Provider.class.getSimpleName() + " on class");
        if (((Boolean)this.option(InstallersOptions.JerseyExtensionsRecognizedByType)).booleanValue()) {
            for (Class<?> ext : EXTENSION_TYPES) {
                res.add("implements " + ext.getSimpleName());
            }
        }
        return res;
    }
}

