/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ru.vyarus.dropwizard.guice.module.context.info.impl.ExtensionItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsSupport;
import ru.vyarus.dropwizard.guice.module.installer.order.OrderComparator;
import ru.vyarus.dropwizard.guice.module.installer.order.Ordered;

public class ExtensionsHolder {
    private final List<FeatureInstaller> installers;
    private final List<ScanItem> scanExtensions = new ArrayList<ScanItem>();
    private List<ExtensionItemInfoImpl> extensionsData;
    private final List<Class<? extends FeatureInstaller>> installerTypes;
    private final Map<Class<? extends FeatureInstaller>, List<Class<?>>> extensions = Maps.newHashMap();

    public ExtensionsHolder(List<FeatureInstaller> installers) {
        this.installers = installers;
        this.installerTypes = Lists.transform(installers, Object::getClass);
    }

    public List<ScanItem> getScanExtensions() {
        return this.scanExtensions;
    }

    public boolean acceptScanCandidate(Class<?> candidate) {
        boolean recognized;
        FeatureInstaller installer = ExtensionsSupport.findInstaller(candidate, this.installers);
        boolean bl = recognized = installer != null;
        if (recognized) {
            this.scanExtensions.add(new ScanItem(candidate, installer));
        }
        return recognized;
    }

    public void registerExtensions(List<ExtensionItemInfoImpl> extensionsData) {
        this.extensionsData = extensionsData;
        for (ExtensionItemInfoImpl ext : extensionsData) {
            Class<? extends FeatureInstaller> installer = ext.getInstalledBy();
            Preconditions.checkArgument((boolean)this.installerTypes.contains(installer), (String)"Installer %s not registered", (Object)installer.getSimpleName());
            if (!this.extensions.containsKey(installer)) {
                this.extensions.put(installer, Lists.newArrayList());
            }
            this.extensions.get(installer).add(ext.getType());
        }
    }

    public List<ExtensionItemInfoImpl> getExtensionsData() {
        return this.extensionsData;
    }

    public List<FeatureInstaller> getInstallers() {
        return this.installers;
    }

    public List<Class<? extends FeatureInstaller>> getInstallerTypes() {
        return this.installerTypes;
    }

    public List<Class<?>> getExtensions(Class<? extends FeatureInstaller> installer) {
        return this.extensions.get(installer);
    }

    public void order() {
        OrderComparator comparator = new OrderComparator();
        for (Class<? extends FeatureInstaller> installer : this.installerTypes) {
            List<Class<?>> extensions;
            if (!Ordered.class.isAssignableFrom(installer) || (extensions = this.extensions.get(installer)) == null || extensions.size() <= 1) continue;
            extensions.sort(comparator);
        }
    }

    public static class ScanItem {
        private final Class<?> type;
        private final FeatureInstaller installer;

        public ScanItem(Class<?> type, FeatureInstaller installer) {
            this.type = type;
            this.installer = installer;
        }

        public Class<?> getType() {
            return this.type;
        }

        public FeatureInstaller getInstaller() {
            return this.installer;
        }
    }
}

