/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;

public final class FeatureUtils {
    private FeatureUtils() {
    }

    public static boolean hasAnnotation(Class<?> type, Class<? extends Annotation> annotation) {
        return FeatureUtils.getAnnotation(type, annotation) != null;
    }

    public static boolean hasAnnotatedAnnotation(Class<?> type, Class<? extends Annotation> annotation) {
        return FeatureUtils.getAnnotatedAnnotation(type, annotation) != null;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> type, Class<T> annotation) {
        T res = null;
        if (!Modifier.isAbstract(type.getModifiers())) {
            for (Class<?> supertype = type; supertype != null && Object.class != supertype; supertype = supertype.getSuperclass()) {
                if (!supertype.isAnnotationPresent(annotation)) continue;
                res = supertype.getAnnotation(annotation);
                break;
            }
        }
        return res;
    }

    public static <T extends Annotation> Annotation getAnnotatedAnnotation(Class<?> type, Class<T> annotation) {
        Annotation res = null;
        if (!Modifier.isAbstract(type.getModifiers())) {
            for (Class<?> supertype = type; supertype != null && Object.class != supertype; supertype = supertype.getSuperclass()) {
                for (Annotation ann : supertype.getAnnotations()) {
                    if (!ann.annotationType().isAnnotationPresent(annotation)) continue;
                    res = ann;
                    break;
                }
                if (res != null) break;
            }
        }
        return res;
    }

    public static boolean is(Class<?> type, Class<?> required) {
        return !Modifier.isAbstract(type.getModifiers()) && required.isAssignableFrom(type);
    }

    public static String getInstallerExtName(Class<? extends FeatureInstaller> installer) {
        return installer.getSimpleName().replace("Installer", "").toLowerCase();
    }

    @SafeVarargs
    public static Method findMethod(Class<?> type, String name, Class<Object> ... args) {
        try {
            return type.getMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(String.format("Failed to obtain method '%s#%s(%s)' of class ", type, name, Arrays.toString(args)), e);
        }
    }

    public static <T> T invokeMethod(Method method, Object instance, Object ... args) {
        boolean acc = method.canAccess(instance);
        method.setAccessible(true);
        try {
            Object object = method.invoke(instance, args);
            return (T)object;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to invoke method '%s#%s(%s)'", method.getDeclaringClass(), method.getName(), Arrays.toString(args)), e);
        }
        finally {
            method.setAccessible(acc);
        }
    }

    public static <T> Class<T> getInstanceClass(T object) {
        Class<?> cls = object.getClass();
        return cls.getName().contains("$$EnhancerByGuice") ? cls.getSuperclass() : cls;
    }
}

