/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.jersey;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import jakarta.inject.Provider;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import org.glassfish.jersey.InjectionManagerProvider;
import org.glassfish.jersey.internal.inject.InjectionManager;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.context.stat.StatsTracker;
import ru.vyarus.dropwizard.guice.module.installer.scanner.InvisibleForScanner;
import ru.vyarus.dropwizard.guice.module.installer.util.JerseyBinding;
import ru.vyarus.dropwizard.guice.module.jersey.hk2.GuiceBridgeActivator;
import ru.vyarus.dropwizard.guice.module.jersey.hk2.InstallerBinder;
import ru.vyarus.dropwizard.guice.module.lifecycle.internal.LifecycleSupport;

@InvisibleForScanner
public class GuiceFeature
implements Feature,
Provider<InjectionManager> {
    private final Provider<Injector> provider;
    private final StatsTracker tracker;
    private final LifecycleSupport lifecycle;
    private final boolean enableBridge;
    private InjectionManager injectionManager;

    public GuiceFeature(Provider<Injector> provider, StatsTracker tracker, LifecycleSupport lifecycle, boolean enableBridge) {
        this.provider = provider;
        this.tracker = tracker;
        this.lifecycle = lifecycle;
        this.enableBridge = enableBridge;
    }

    public boolean configure(FeatureContext context) {
        this.tracker.startJerseyTimer(Stat.JerseyTime);
        this.injectionManager = InjectionManagerProvider.getInjectionManager((FeatureContext)context);
        this.lifecycle.jerseyConfiguration(this.injectionManager);
        Injector injector = (Injector)this.provider.get();
        if (this.enableBridge) {
            Preconditions.checkState((boolean)JerseyBinding.isBridgeAvailable(), (Object)"HK2 bridge is requested, but dependency not found: 'org.glassfish.hk2:guice-bridge:2.6.1' (check that dependency version match HK2 version used in your dropwizard)");
            new GuiceBridgeActivator(this.injectionManager, injector).activate();
        }
        context.register((Object)new InstallerBinder(injector, this.tracker, this.lifecycle));
        this.tracker.stopJerseyTimer(Stat.JerseyTime);
        return true;
    }

    public InjectionManager get() {
        return (InjectionManager)Preconditions.checkNotNull((Object)this.injectionManager, (Object)"Jersey InjectionManager is not yet available");
    }
}

