/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.yaml.bind;

import com.google.common.collect.LinkedHashMultimap;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.util.Providers;
import io.dropwizard.core.Configuration;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigPath;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;
import ru.vyarus.dropwizard.guice.module.yaml.bind.Config;
import ru.vyarus.dropwizard.guice.module.yaml.bind.ConfigImpl;
import ru.vyarus.java.generics.resolver.context.container.ParameterizedTypeImpl;

public class ConfigBindingModule
extends AbstractModule {
    private final Configuration configuration;
    private final ConfigurationTree tree;

    public ConfigBindingModule(Configuration configuration, ConfigurationTree tree) {
        this.configuration = configuration;
        this.tree = tree;
    }

    protected void configure() {
        this.bind(ConfigurationTree.class).toInstance((Object)this.tree);
        this.bindCustomQualifiers();
        this.bindRootTypes();
        this.bindUniqueSubConfigurations();
        this.bindValuePaths();
    }

    private void bindCustomQualifiers() {
        LinkedHashMultimap bindings = LinkedHashMultimap.create();
        for (ConfigPath item : this.tree.getPaths()) {
            if (item.getQualifier() == null) continue;
            Key key = Key.get((Type)item.getDeclaredTypeWithGenerics(), (Annotation)item.getQualifier());
            bindings.put((Object)key, (Object)item);
        }
        for (Key key : bindings.keySet()) {
            Collection values = bindings.get((Object)key);
            ConfigPath first = (ConfigPath)values.iterator().next();
            Set value = first.getValue();
            Key bindingKey = key;
            if (values.size() > 1) {
                value = values.stream().map(ConfigPath::getValue).collect(Collectors.toSet());
                bindingKey = Key.get((Type)new ParameterizedTypeImpl(Set.class, new Type[]{first.getDeclaredTypeWithGenerics()}), (Annotation)first.getQualifier());
            }
            this.bindValue(this.bind(bindingKey), value);
        }
    }

    private void bindRootTypes() {
        for (Class type : this.tree.getRootTypes()) {
            if (!type.isInterface()) {
                this.bind(type).toInstance((Object)this.configuration);
            }
            this.bind(type).annotatedWith(Config.class).toInstance((Object)this.configuration);
        }
    }

    private void bindUniqueSubConfigurations() {
        for (ConfigPath item : this.tree.getUniqueTypePaths()) {
            this.bindValue(this.bind(Key.get((Type)item.getDeclaredTypeWithGenerics(), Config.class)), item.getValue());
        }
    }

    private void bindValuePaths() {
        for (ConfigPath item : this.tree.getPaths()) {
            this.bindValue(this.bind(Key.get((Type)item.getDeclaredTypeWithGenerics(), (Annotation)new ConfigImpl(item.getPath()))), item.getValue());
        }
    }

    private void bindValue(LinkedBindingBuilder binding, Object value) {
        if (value != null) {
            binding.toInstance(value);
        } else {
            binding.toProvider(Providers.of(null));
        }
    }
}

