/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.env;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import java.util.LinkedHashSet;
import java.util.Set;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.function.ThrowingConsumer;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.EventContext;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.TestExecutionListener;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track.GuiceyTestTime;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track.TestExtensionsTracker;

public class ListenersSupport {
    private final Set<TestExecutionListener> listeners = new LinkedHashSet<TestExecutionListener>();
    private final TestExtensionsTracker tracker;

    public ListenersSupport(TestExtensionsTracker tracker) {
        this.tracker = tracker;
    }

    public void addListener(TestExecutionListener listener) {
        this.listeners.add((TestExecutionListener)Preconditions.checkNotNull((Object)listener, (Object)"Listener must not be null"));
    }

    public void broadcastStarting(ExtensionContext context) {
        this.broadcast((ThrowingConsumer<TestExecutionListener>)((ThrowingConsumer)listener -> listener.starting(new EventContext(context, this.tracker.debug))));
    }

    public void broadcastStart(ExtensionContext context) {
        this.broadcast((ThrowingConsumer<TestExecutionListener>)((ThrowingConsumer)listener -> listener.started(new EventContext(context, this.tracker.debug))));
    }

    public void broadcastBeforeAll(ExtensionContext context) {
        this.broadcast((ThrowingConsumer<TestExecutionListener>)((ThrowingConsumer)listener -> listener.beforeAll(new EventContext(context, this.tracker.debug))));
    }

    public void broadcastBefore(ExtensionContext context) {
        this.broadcast((ThrowingConsumer<TestExecutionListener>)((ThrowingConsumer)listener -> listener.beforeEach(new EventContext(context, this.tracker.debug))));
    }

    public void broadcastAfter(ExtensionContext context) {
        this.broadcast((ThrowingConsumer<TestExecutionListener>)((ThrowingConsumer)listener -> listener.afterEach(new EventContext(context, this.tracker.debug))));
    }

    public void broadcastAfterAll(ExtensionContext context) {
        this.broadcast((ThrowingConsumer<TestExecutionListener>)((ThrowingConsumer)listener -> listener.afterAll(new EventContext(context, this.tracker.debug))));
    }

    public void broadcastStopping(ExtensionContext context) {
        this.broadcast((ThrowingConsumer<TestExecutionListener>)((ThrowingConsumer)listener -> listener.stopping(new EventContext(context, this.tracker.debug))));
    }

    public void broadcastStop(ExtensionContext context) {
        this.broadcast((ThrowingConsumer<TestExecutionListener>)((ThrowingConsumer)listener -> listener.stopped(new EventContext(context, this.tracker.debug))));
    }

    private void broadcast(ThrowingConsumer<TestExecutionListener> action) {
        if (!this.listeners.isEmpty()) {
            Stopwatch timer = Stopwatch.createStarted();
            this.listeners.forEach(l -> {
                try {
                    action.accept(l);
                }
                catch (Throwable ex) {
                    Throwables.throwIfUnchecked((Throwable)ex);
                    throw new IllegalStateException("Failed to execute listener", ex);
                }
            });
            this.tracker.performanceTrack(GuiceyTestTime.TestListeners, timer.elapsed());
        }
    }
}

