/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.env;

import io.dropwizard.core.Configuration;
import java.lang.annotation.Annotation;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import ru.vyarus.dropwizard.guice.test.jupiter.env.ListenersSupport;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedField;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.TestFieldUtils;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.TestExecutionListener;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.lambda.LambdaTestListener;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.lambda.ListenerEvent;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.lambda.TestExecutionListenerLambdaAdapter;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.ExtensionBuilder;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.ExtensionConfig;

public class TestExtension
extends ExtensionBuilder<Configuration, TestExtension, ExtensionConfig> {
    private final ExtensionContext context;
    private final ListenersSupport listeners;
    private TestExecutionListenerLambdaAdapter listenerAdapter;

    public TestExtension(ExtensionConfig cfg, ExtensionContext context, ListenersSupport listeners) {
        super(cfg);
        this.context = context;
        this.listeners = listeners;
    }

    public boolean isDebug() {
        return this.cfg.tracker.debug;
    }

    public boolean isApplicationStartedForClass() {
        return this.getJunitContext().getTestMethod().isEmpty();
    }

    public ExtensionContext getJunitContext() {
        return this.context;
    }

    public TestExtension listen(TestExecutionListener listener) {
        this.listeners.addListener(listener);
        return this;
    }

    public TestExtension onApplicationStarting(LambdaTestListener listener) {
        this.registerListener(ListenerEvent.Starting, listener);
        return this;
    }

    public TestExtension onApplicationStart(LambdaTestListener listener) {
        this.registerListener(ListenerEvent.Started, listener);
        return this;
    }

    public TestExtension onBeforeAll(LambdaTestListener listener) {
        this.registerListener(ListenerEvent.BeforeAll, listener);
        return this;
    }

    public TestExtension onBeforeEach(LambdaTestListener listener) {
        this.registerListener(ListenerEvent.BeforeEach, listener);
        return this;
    }

    public TestExtension onAfterEach(LambdaTestListener listener) {
        this.registerListener(ListenerEvent.AfterEach, listener);
        return this;
    }

    public TestExtension onAfterAll(LambdaTestListener listener) {
        this.registerListener(ListenerEvent.AfterAll, listener);
        return this;
    }

    public TestExtension onApplicationStopping(LambdaTestListener listener) {
        this.registerListener(ListenerEvent.Stopping, listener);
        return this;
    }

    public TestExtension onApplicationStop(LambdaTestListener listener) {
        this.registerListener(ListenerEvent.Stopped, listener);
        return this;
    }

    public <A extends Annotation, T> List<AnnotatedField<A, T>> findAnnotatedFields(Class<A> annotation, Class<T> requiredFieldType) {
        return TestFieldUtils.findAnnotatedFields(this.context.getRequiredTestClass(), annotation, requiredFieldType);
    }

    private void registerListener(ListenerEvent event, LambdaTestListener listener) {
        if (this.listenerAdapter == null) {
            this.listenerAdapter = new TestExecutionListenerLambdaAdapter();
            this.listen(this.listenerAdapter);
        }
        this.listenerAdapter.listen(event, listener);
    }
}

