/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.env.field;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.platform.commons.support.AnnotationSupport;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedField;

public final class TestFieldUtils {
    private TestFieldUtils() {
    }

    public static <A extends Annotation, T> List<AnnotatedField<A, T>> findAnnotatedFields(Class<?> testClass, Class<A> ann, Class<T> requiredType) {
        List fields = AnnotationSupport.findAnnotatedFields(testClass, ann);
        ArrayList<AnnotatedField<A, T>> res = new ArrayList<AnnotatedField<A, T>>(fields.size());
        for (Field field2 : fields) {
            if (!requiredType.isAssignableFrom(field2.getType())) {
                throw new IllegalStateException(String.format("Field %s annotated with @%s, but its type is not %s", TestFieldUtils.toString(field2), ann.getSimpleName(), requiredType.getSimpleName()));
            }
            res.add(new AnnotatedField(field2.getAnnotation(ann), field2, testClass));
        }
        res.sort(Comparator.comparing(field -> field.isStatic() ? 0 : 1));
        return res;
    }

    public static <A extends Annotation, T> List<AnnotatedField<A, T>> getInheritedFields(List<AnnotatedField<A, T>> fields) {
        return fields.stream().filter(fieldAccess -> !fieldAccess.isTestOwnField()).collect(Collectors.toList());
    }

    public static <A extends Annotation, T> List<AnnotatedField<A, T>> getTestOwnFields(List<AnnotatedField<A, T>> fields) {
        return fields.stream().filter(AnnotatedField::isTestOwnField).collect(Collectors.toList());
    }

    public static <A extends Annotation, T> List<T> getValues(List<AnnotatedField<A, T>> fields, Object instance) {
        ArrayList<T> res = new ArrayList<T>();
        for (AnnotatedField<A, T> field : fields) {
            res.add(field.getValue(instance));
        }
        return res;
    }

    public static String toString(Field field) {
        return RenderUtils.getFullClassName(field.getDeclaringClass()) + "." + field.getName();
    }
}

