/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.env.listen.lambda;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.EventContext;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.TestExecutionListener;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.lambda.LambdaTestListener;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.lambda.ListenerEvent;

public class TestExecutionListenerLambdaAdapter
implements TestExecutionListener {
    private final Multimap<ListenerEvent, LambdaTestListener> listeners = ArrayListMultimap.create();

    public void listen(ListenerEvent event, LambdaTestListener listener) {
        this.listeners.put((Object)event, (Object)listener);
    }

    @Override
    public void starting(EventContext context) throws Exception {
        this.callListeners(context, ListenerEvent.Starting);
    }

    @Override
    public void started(EventContext context) throws Exception {
        this.callListeners(context, ListenerEvent.Started);
    }

    @Override
    public void beforeAll(EventContext context) throws Exception {
        this.callListeners(context, ListenerEvent.BeforeAll);
    }

    @Override
    public void beforeEach(EventContext context) throws Exception {
        this.callListeners(context, ListenerEvent.BeforeEach);
    }

    @Override
    public void afterEach(EventContext context) throws Exception {
        this.callListeners(context, ListenerEvent.AfterEach);
    }

    @Override
    public void afterAll(EventContext context) throws Exception {
        this.callListeners(context, ListenerEvent.AfterAll);
    }

    @Override
    public void stopping(EventContext context) throws Exception {
        this.callListeners(context, ListenerEvent.Stopping);
    }

    @Override
    public void stopped(EventContext context) throws Exception {
        this.callListeners(context, ListenerEvent.Stopped);
    }

    private void callListeners(EventContext context, ListenerEvent event) throws Exception {
        for (LambdaTestListener listener : this.listeners.get((Object)event)) {
            listener.onTestEvent(context);
        }
    }
}

