/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.inject.Injector;
import io.dropwizard.core.Configuration;
import io.dropwizard.testing.DropwizardTestSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.hook.ConfigurationHooksSupport;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.context.SharedConfigurationState;
import ru.vyarus.dropwizard.guice.test.ClientSupport;
import ru.vyarus.dropwizard.guice.test.EnableHook;
import ru.vyarus.dropwizard.guice.test.TestSupport;
import ru.vyarus.dropwizard.guice.test.builder.TestSupportHolder;
import ru.vyarus.dropwizard.guice.test.jupiter.env.EnableSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.env.ListenersSupport;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestEnvironmentSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedField;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.TestFieldUtils;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.TestParametersSupport;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.ExtensionConfig;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track.GuiceyTestTime;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track.TestExtensionsTracker;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.spy.SpyFieldsSupport;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.track.TrackerFieldsSupport;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideUtils;
import ru.vyarus.dropwizard.guice.test.util.HooksUtil;
import ru.vyarus.dropwizard.guice.test.util.ReusableAppUtils;
import ru.vyarus.dropwizard.guice.test.util.StoredReusableApp;
import ru.vyarus.dropwizard.guice.test.util.TestSetupUtils;

public abstract class GuiceyExtensionsSupport
extends TestParametersSupport
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiceyExtensionsSupport.class);
    private static final String DW_SUPPORT = "DW_SUPPORT";
    private static final String INJECTOR = "INJECTOR";
    private static final String DW_SUPPORT_GLOBAL = "DW_SUPPORT_GLOBAL";
    private static final String DW_CLIENT = "DW_CLIENT";
    private static final String INHERITED_DW_SUPPORT = "INHERITED_DW_SUPPORT";
    private static final String PER_METHOD_DW_SUPPORT = "PER_METHOD_DW_SUPPORT";
    private static final String INJECTION_INTSTANCE_HASH = "INJECTION_INTSTANCE_HASH";
    private static final Object SYNC = new Object();
    protected final TestExtensionsTracker tracker;
    protected final ListenersSupport listeners;

    public GuiceyExtensionsSupport(TestExtensionsTracker tracker) {
        this.tracker = tracker;
        this.listeners = new ListenersSupport(tracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAll(ExtensionContext context) throws Exception {
        Stopwatch timer = Stopwatch.createStarted();
        this.tracker.lifecyclePhase(context, GuiceyTestTime.BeforeAll);
        Object object = SYNC;
        synchronized (object) {
            this.checkReusableApp(context);
        }
        if (!GuiceyExtensionsSupport.lookupSupport(context).isPresent()) {
            this.start(context, null);
        } else {
            ExtensionContext.Store localStore = this.getLocalExtensionStore(context);
            Preconditions.checkState((localStore.get((Object)INHERITED_DW_SUPPORT) == null ? 1 : 0) != 0, (Object)"Storage assumptions were wrong or unexpected junit usage appear. Please report this case to guicey developer.");
            localStore.put((Object)INHERITED_DW_SUPPORT, (Object)true);
        }
        this.listeners.broadcastBeforeAll(context);
        this.tracker.performanceTrack(GuiceyTestTime.BeforeAll, timer.elapsed());
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Stopwatch timer = Stopwatch.createStarted();
        this.tracker.lifecyclePhase(context, GuiceyTestTime.BeforeEach);
        if (!GuiceyExtensionsSupport.lookupSupport(context).isPresent()) {
            this.start(context, context.getTestInstance().get());
            this.getLocalExtensionStore(context).put((Object)PER_METHOD_DW_SUPPORT, (Object)true);
        }
        this.injectMembers(context);
        this.listeners.broadcastBefore(context);
        this.tracker.performanceTrack(GuiceyTestTime.BeforeEach, timer.elapsed());
        this.tracker.logGuiceyTestTime(GuiceyTestTime.BeforeEach, context);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        boolean perMethod;
        Stopwatch timer = Stopwatch.createStarted();
        this.tracker.lifecyclePhase(context, GuiceyTestTime.AfterEach);
        boolean bl = perMethod = this.getLocalExtensionStore(context).get((Object)PER_METHOD_DW_SUPPORT) != null;
        if (perMethod) {
            this.stop(context);
        }
        this.listeners.broadcastAfter(context);
        this.tracker.performanceTrack(GuiceyTestTime.AfterEach, timer.elapsed());
        if (perMethod) {
            this.tracker.logGuiceyTestTime(GuiceyTestTime.AfterEach, context);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        Stopwatch timer = Stopwatch.createStarted();
        this.tracker.lifecyclePhase(context, GuiceyTestTime.AfterAll);
        if (GuiceyExtensionsSupport.lookupSupport(context).isPresent() && this.getLocalExtensionStore(context).remove((Object)INHERITED_DW_SUPPORT) == null) {
            this.stop(context);
        }
        this.listeners.broadcastAfterAll(context);
        this.tracker.performanceTrack(GuiceyTestTime.AfterAll, timer.elapsed());
        this.tracker.logGuiceyTestTime(GuiceyTestTime.AfterAll, context);
    }

    public static <C extends Configuration> Optional<DropwizardTestSupport<C>> lookupSupport(ExtensionContext extensionContext) {
        return Optional.ofNullable((DropwizardTestSupport)GuiceyExtensionsSupport.getExtensionStore(extensionContext).get((Object)DW_SUPPORT));
    }

    public static Optional<Injector> lookupInjector(ExtensionContext extensionContext) {
        return Optional.ofNullable((Injector)GuiceyExtensionsSupport.getExtensionStore(extensionContext).get((Object)INJECTOR));
    }

    public static Optional<ClientSupport> lookupClient(ExtensionContext extensionContext) {
        return Optional.ofNullable((ClientSupport)GuiceyExtensionsSupport.getExtensionStore(extensionContext).get((Object)DW_CLIENT));
    }

    public static boolean isReusableAppUsed(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.getExtensionStore(extensionContext).get((Object)DW_SUPPORT_GLOBAL) != null;
    }

    public static boolean closeReusableApp(ExtensionContext extensionContext) {
        Class baseClass = (Class)GuiceyExtensionsSupport.getExtensionStore(extensionContext).get((Object)DW_SUPPORT_GLOBAL);
        return baseClass != null && ReusableAppUtils.closeGlobalApp(extensionContext, baseClass);
    }

    protected abstract ExtensionConfig getConfig(ExtensionContext var1);

    protected abstract DropwizardTestSupport<?> prepareTestSupport(String var1, ExtensionContext var2, List<TestEnvironmentSetup> var3);

    @Override
    protected DropwizardTestSupport<?> getSupport(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.lookupSupport(extensionContext).orElse(null);
    }

    @Override
    protected ClientSupport getClient(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.lookupClient(extensionContext).orElse(null);
    }

    @Override
    protected Optional<Injector> getInjector(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.lookupInjector(extensionContext);
    }

    protected static ExtensionContext.Store getExtensionStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{GuiceyExtensionsSupport.class}));
    }

    private ExtensionContext.Store getLocalExtensionStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{GuiceyExtensionsSupport.class, context.getRequiredTestClass()}));
    }

    private void checkReusableApp(ExtensionContext context) throws Exception {
        ExtensionConfig config = this.getConfig(context);
        if (config.reuseApp) {
            String source = config.reuseSource;
            StoredReusableApp globalApp = ReusableAppUtils.getGlobalApp(context, config.reuseDeclarationClass);
            ExtensionContext.Store store = GuiceyExtensionsSupport.getExtensionStore(context);
            if (globalApp != null) {
                Preconditions.checkState((boolean)globalApp.getSource().equals(config.reuseSource), (String)"Can't apply reusable app instance from %s in test %s because different reusable app (%s)is already registered", (Object)source, (Object)context.getRequiredTestClass().getSimpleName(), (Object)globalApp.getSource());
                Stopwatch timer = Stopwatch.createStarted();
                new FieldSupport(context.getRequiredTestClass(), null, null).hintIgnoredFields(config.reuseDeclarationClass);
                this.tracker.performanceTrack(GuiceyTestTime.ReusableAppWarnings, timer.elapsed());
                if (store.get((Object)DW_SUPPORT) == null) {
                    store.put((Object)DW_SUPPORT, globalApp.getSupport());
                    store.put((Object)INJECTOR, (Object)TestSupport.getInjector(globalApp.getSupport()));
                    store.put((Object)DW_CLIENT, (Object)globalApp.getClient());
                } else {
                    Preconditions.checkState((boolean)store.get((Object)DW_SUPPORT).equals(globalApp.getSupport()), (String)"Can't apply reusable app instance from %s in test %s context because it already contains started app", (Object)source, (Object)context.getRequiredTestClass().getSimpleName());
                }
            } else {
                this.start(context, null);
                ReusableAppUtils.registerGlobalApp(context, new StoredReusableApp(config.reuseDeclarationClass, source, GuiceyExtensionsSupport.lookupSupport(context).get(), GuiceyExtensionsSupport.lookupClient(context).get()));
            }
            if (store.get((Object)DW_SUPPORT_GLOBAL) == null) {
                store.put((Object)DW_SUPPORT_GLOBAL, config.reuseDeclarationClass);
            }
        }
    }

    private void start(ExtensionContext context, Object testInstance) throws Exception {
        ExtensionConfig config = this.getConfig(context);
        ExtensionContext.Store store = GuiceyExtensionsSupport.getExtensionStore(context);
        FieldSupport fields = new FieldSupport(context.getRequiredTestClass(), testInstance, this.tracker);
        if (config.reuseApp) {
            fields.hintIncorrectFieldsUsage(config.reuseDeclarationClass);
        }
        fields.activateBaseHooks();
        String configPrefix = ConfigOverrideUtils.createPrefix(context);
        DropwizardTestSupport<?> support = this.prepareTestSupport(configPrefix, context, this.addDefaultSetupObjects(fields.getSetupObjects(), config.defaultExtensionsEnabled));
        fields.activateClassHooks();
        store.put((Object)DW_SUPPORT, support);
        ClientSupport client = new ClientSupport(support, config.clientFactory);
        store.put((Object)DW_CLIENT, (Object)client);
        TestSupportHolder.setContext(support, client);
        this.tracker.enableDebugFromSystemProperty();
        this.listeners.broadcastStarting(context);
        this.tracker.logUsedHooksAndSetupObjects(configPrefix);
        Stopwatch timer = Stopwatch.createStarted();
        support.before();
        store.put((Object)INJECTOR, (Object)TestSupport.getInjector(support));
        this.tracker.performanceTrack(GuiceyTestTime.SupportStart, timer.elapsed());
        this.tracker.logOverriddenConfigs(configPrefix);
        this.listeners.broadcastStart(context);
    }

    private void stop(ExtensionContext context) throws Exception {
        ClientSupport client;
        ConfigurationHooksSupport.reset();
        DropwizardTestSupport<?> support = this.getSupport(context);
        if (support != null) {
            this.listeners.broadcastStopping(context);
            Stopwatch timer = Stopwatch.createStarted();
            support.after();
            TestSupportHolder.reset();
            this.tracker.performanceTrack(GuiceyTestTime.SupportStop, timer.stop().elapsed());
            this.listeners.broadcastStop(context);
            if (GuiceyExtensionsSupport.lookupInjector(context).isPresent()) {
                SharedConfigurationState.get(support.getEnvironment()).ifPresent(SharedConfigurationState::shutdown);
            }
        }
        if ((client = this.getClient(context)) != null) {
            client.close();
        }
    }

    private List<TestEnvironmentSetup> addDefaultSetupObjects(List<TestEnvironmentSetup> fields, boolean useDefaultExtensions) {
        ArrayList<TestEnvironmentSetup> res = new ArrayList<TestEnvironmentSetup>(fields);
        if (useDefaultExtensions) {
            res.addAll(this.tracker.lookupExtensions(TestSetupUtils.lookup()));
            res.addAll(this.tracker.defaultExtensions(new SpyFieldsSupport(), new TrackerFieldsSupport()));
        }
        return res;
    }

    private void injectMembers(ExtensionContext context) {
        boolean injectOnce;
        Object testInstance = context.getTestInstance().orElseThrow(() -> new IllegalStateException("Unable to get the current test instance"));
        Integer instanceHash = System.identityHashCode(testInstance);
        DropwizardTestSupport support = (DropwizardTestSupport)Preconditions.checkNotNull(this.getSupport(context), (Object)"Guicey test support was not initialized: most likely, you are trying to manually register extension using non-static field - such usage is not supported.");
        ExtensionContext.Store localStore = this.getLocalExtensionStore((ExtensionContext)context.getParent().get());
        HashSet<Integer> lastInstanceHash = (HashSet<Integer>)localStore.get((Object)INJECTION_INTSTANCE_HASH, Set.class);
        if (lastInstanceHash == null) {
            lastInstanceHash = new HashSet<Integer>();
        }
        if (!(injectOnce = this.getConfig((ExtensionContext)context).injectOnce) || !lastInstanceHash.contains(instanceHash)) {
            this.tracker.performanceTrack(GuiceyTestTime.GuiceInjection, TestSupport.injectBeans(support, testInstance));
            lastInstanceHash.add(instanceHash);
            localStore.put((Object)INJECTION_INTSTANCE_HASH, lastInstanceHash);
        }
    }

    private static class FieldSupport {
        private final Class<?> testClass;
        private final Object instance;
        private final TestExtensionsTracker tracker;
        private final List<AnnotatedField<EnableHook, GuiceyConfigurationHook>> parentHookFields;
        private final List<AnnotatedField<EnableHook, GuiceyConfigurationHook>> ownHookFields;
        private final List<AnnotatedField<EnableSetup, TestEnvironmentSetup>> extensionFields;

        FieldSupport(Class<?> testClass, Object instance, TestExtensionsTracker tracker) {
            this.testClass = testClass;
            this.instance = instance;
            this.tracker = tracker;
            Stopwatch timer = Stopwatch.createStarted();
            boolean staticFieldsRequired = instance == null;
            this.ownHookFields = TestFieldUtils.findAnnotatedFields(testClass, EnableHook.class, GuiceyConfigurationHook.class);
            if (staticFieldsRequired) {
                this.ownHookFields.forEach(AnnotatedField::requireStatic);
            }
            this.parentHookFields = TestFieldUtils.getInheritedFields(this.ownHookFields);
            this.ownHookFields.removeAll(this.parentHookFields);
            if (tracker != null) {
                tracker.performanceTrack(GuiceyTestTime.GuiceyFieldsSearch, timer.stop().elapsed());
            }
            timer.reset().start();
            this.extensionFields = TestFieldUtils.findAnnotatedFields(testClass, EnableSetup.class, TestEnvironmentSetup.class);
            if (staticFieldsRequired) {
                this.extensionFields.forEach(AnnotatedField::requireStatic);
            }
            if (tracker != null) {
                tracker.performanceTrack(GuiceyTestTime.GuiceyFieldsSearch, timer.stop().elapsed());
            }
        }

        public void hintIncorrectFieldsUsage(Class<?> declarationClass) {
            Stopwatch timer = Stopwatch.createStarted();
            List<String> wrong = this.findNonBaseFields(declarationClass);
            if (!wrong.isEmpty()) {
                LOGGER.warn("The following extensions were used during reusable app startup in test {}, but they did not belong to base class {} hierarchy where reusable app is declared and so would be ignored if reusable app would start by different test: \n{}", new Object[]{this.testClass.getName(), declarationClass.getName(), Joiner.on((String)"\n").join(wrong)});
            }
            this.tracker.performanceTrack(GuiceyTestTime.GuiceyFieldsSearch, timer.stop().elapsed());
        }

        public void hintIgnoredFields(Class<?> declarationClass) {
            Stopwatch timer = Stopwatch.createStarted();
            List<String> wrong = this.findNonBaseFields(declarationClass);
            if (!wrong.isEmpty()) {
                LOGGER.warn("The following extensions were ignored in test {} because reusable application was already started by another test: \n{}", (Object)this.testClass.getName(), (Object)Joiner.on((String)"\n").join(wrong));
            }
            if (this.tracker != null) {
                this.tracker.performanceTrack(GuiceyTestTime.GuiceyFieldsSearch, timer.stop().elapsed());
            }
        }

        public List<TestEnvironmentSetup> getSetupObjects() {
            Stopwatch timer = Stopwatch.createStarted();
            try {
                this.tracker.extensionsFromFields(this.extensionFields, this.instance);
                List<TestEnvironmentSetup> list = this.extensionFields.isEmpty() ? Collections.emptyList() : TestFieldUtils.getValues(this.extensionFields, this.instance);
                return list;
            }
            finally {
                this.tracker.performanceTrack(GuiceyTestTime.GuiceyFieldsSearch, timer.stop().elapsed());
            }
        }

        public void activateBaseHooks() {
            Stopwatch timer = Stopwatch.createStarted();
            this.activateFieldHooks(this.parentHookFields);
            this.tracker.hooksFromFields(this.parentHookFields, true, this.instance);
            this.tracker.performanceTrack(GuiceyTestTime.GuiceyFieldsSearch, timer.stop().elapsed());
        }

        public void activateClassHooks() {
            Stopwatch timer = Stopwatch.createStarted();
            this.activateFieldHooks(this.ownHookFields);
            this.tracker.hooksFromFields(this.ownHookFields, false, this.instance);
            this.tracker.performanceTrack(GuiceyTestTime.GuiceyFieldsSearch, timer.stop().elapsed());
        }

        private List<String> findNonBaseFields(Class<?> declarationClass) {
            ArrayList<String> wrong = new ArrayList<String>();
            this.checkFieldsDeclaration(wrong, this.parentHookFields, declarationClass);
            this.checkFieldsDeclaration(wrong, this.ownHookFields, declarationClass);
            this.checkFieldsDeclaration(wrong, this.extensionFields, declarationClass);
            return wrong;
        }

        private void checkFieldsDeclaration(List<String> wrong, List<AnnotatedField<?, ?>> fields, Class<?> baseClass) {
            fields.forEach(field -> {
                if (!field.getDeclaringClass().isAssignableFrom(baseClass)) {
                    wrong.add("\t" + field.getDeclaringClass().getName() + "." + field.getName() + " (" + field.getType().getSimpleName() + ")");
                }
            });
        }

        private void activateFieldHooks(List<AnnotatedField<EnableHook, GuiceyConfigurationHook>> fields) {
            Stopwatch timer = Stopwatch.createStarted();
            HooksUtil.register(TestFieldUtils.getValues(fields, this.instance));
            this.tracker.performanceTrack(GuiceyTestTime.HooksRegistration, timer.elapsed());
        }
    }
}

