/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext.conf;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dropwizard.core.Configuration;
import io.dropwizard.testing.ConfigOverride;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.function.ThrowingSupplier;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.installer.util.InstanceUtils;
import ru.vyarus.dropwizard.guice.test.client.TestClientFactory;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestEnvironmentSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.track.TestExtensionsTracker;
import ru.vyarus.dropwizard.guice.test.util.ConfigModifier;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideUtils;
import ru.vyarus.dropwizard.guice.test.util.HooksUtil;
import ru.vyarus.dropwizard.guice.test.util.TestSetupUtils;

public abstract class ExtensionConfig {
    public String[] configOverrides = new String[0];
    public ThrowingSupplier<? extends Configuration> confInstance;
    public final List<ConfigOverride> configOverrideObjects = new ArrayList<ConfigOverride>();
    public final List<ConfigModifier<?>> configModifiers = new ArrayList();
    public final List<GuiceyConfigurationHook> hooks = new ArrayList<GuiceyConfigurationHook>();
    public final List<TestEnvironmentSetup> extensions = new ArrayList<TestEnvironmentSetup>();
    public TestClientFactory clientFactory;
    public boolean injectOnce;
    public boolean defaultExtensionsEnabled = true;
    public final TestExtensionsTracker tracker;
    public boolean reuseApp;
    public Class<?> reuseDeclarationClass;
    public String reuseSource;

    public ExtensionConfig(TestExtensionsTracker tracker) {
        this.tracker = tracker;
    }

    @SafeVarargs
    public final void extensionsFromAnnotation(Class<? extends Annotation> ann, Class<? extends TestEnvironmentSetup> ... exts) {
        this.extensions.addAll(TestSetupUtils.create(exts));
        this.tracker.extensionsFromAnnotation(ann, exts);
    }

    @SafeVarargs
    public final void hooksFromAnnotation(Class<? extends Annotation> ann, Class<? extends GuiceyConfigurationHook> ... exts) {
        this.hooks.addAll(HooksUtil.create(exts));
        this.tracker.hooksFromAnnotation(ann, exts);
    }

    public final void hookInstances(GuiceyConfigurationHook ... exts) {
        Collections.addAll(this.hooks, exts);
        this.tracker.hookInstances(exts);
    }

    @SafeVarargs
    public final void hookClasses(Class<? extends GuiceyConfigurationHook> ... exts) {
        this.hooks.addAll(HooksUtil.create(exts));
        this.tracker.hookClasses(exts);
    }

    @SafeVarargs
    public final void configModifiersFromAnnotation(Class<? extends Annotation> ann, Class<? extends ConfigModifier<?>> ... modifiers) {
        this.configModifiers.addAll(ConfigOverrideUtils.createModifiers(modifiers));
        this.tracker.configModifiersFromAnnotation(ann, modifiers);
    }

    @SafeVarargs
    public final void configModifierClasses(Class<? extends ConfigModifier<?>> ... modifiers) {
        this.configModifiers.addAll(ConfigOverrideUtils.createModifiers(modifiers));
        this.tracker.configModifierClasses(modifiers);
    }

    public final void configModifierInstances(ConfigModifier<?> ... modifiers) {
        Collections.addAll(this.configModifiers, modifiers);
        this.tracker.configModifierInstances(modifiers);
    }

    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"})
    public final void clientFactory(Class<? extends TestClientFactory> factoryType) {
        try {
            this.clientFactory = InstanceUtils.create(factoryType);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to instantiate test client factory", ex);
        }
    }

    public <C extends Configuration> C getConfiguration(String configPath) {
        Configuration cfg = null;
        if (this.confInstance != null) {
            Preconditions.checkState((boolean)configPath.isEmpty(), (String)"Configuration path can't be used with manual configuration instance: %s", (Object)configPath);
            Preconditions.checkState((this.configOverrides.length == 0 ? 1 : 0) != 0, (String)"Configuration overrides can't be used with manual configuration instance: %s", (Object)Arrays.toString(this.configOverrides));
            Preconditions.checkState((boolean)this.configOverrideObjects.isEmpty(), (Object)"Configuration overrides can't be used with manual configuration instance");
            try {
                cfg = (Configuration)this.confInstance.get();
            }
            catch (Throwable e) {
                throw new IllegalStateException("Manual configuration instance construction failed", e);
            }
            Preconditions.checkNotNull((Object)cfg, (Object)"Configuration can't be null");
        }
        return (C)cfg;
    }
}

