/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext.log;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestExtension;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedField;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedTestFieldSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.EventContext;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.log.RecordLogs;
import ru.vyarus.dropwizard.guice.test.log.RecordLogsHook;
import ru.vyarus.dropwizard.guice.test.log.RecordedLogs;

public class LogFieldsSupport
extends AnnotatedTestFieldSetup<RecordLogs, RecordedLogs> {
    private static final String TEST_LOGS_FIELDS = "TEST_LOGS_FIELDS";
    private static final String FIELD_RECORDER = "FIELD_RECORDER";
    private final RecordLogsHook hook = new RecordLogsHook();

    public LogFieldsSupport() {
        super(RecordLogs.class, RecordedLogs.class, TEST_LOGS_FIELDS);
    }

    @Override
    protected void fieldDetected(ExtensionContext context, AnnotatedField<RecordLogs, RecordedLogs> field) {
        RecordLogs config = field.getAnnotation();
        RecordedLogs logs = this.hook.record().loggers(config.value()).loggers(config.loggers()).recorderName(field.toStringField()).start(config.level());
        field.setCustomData(FIELD_RECORDER, logs);
    }

    @Override
    protected void registerHooks(TestExtension extension) {
        extension.hooks(this.hook);
    }

    @Override
    protected <K> void initializeField(AnnotatedField<RecordLogs, RecordedLogs> field, RecordedLogs userValue) {
    }

    @Override
    protected void beforeValueInjection(EventContext context, AnnotatedField<RecordLogs, RecordedLogs> field) {
    }

    @Override
    protected RecordedLogs injectFieldValue(EventContext context, AnnotatedField<RecordLogs, RecordedLogs> field) {
        return (RecordedLogs)Preconditions.checkNotNull((Object)((RecordedLogs)field.getCustomData(FIELD_RECORDER)));
    }

    @Override
    protected void report(EventContext context, List<AnnotatedField<RecordLogs, RecordedLogs>> annotatedFields) {
        StringBuilder report = new StringBuilder("\nApplied log recorders (@").append(RecordLogs.class.getSimpleName()).append(") on ").append(this.setupContextName).append("\n\n");
        this.fields.forEach(field -> {
            RecordLogs config = (RecordLogs)field.getAnnotation();
            ArrayList loggers = new ArrayList();
            Arrays.stream(config.value()).map(Class::getSimpleName).forEach(loggers::add);
            Collections.addAll(loggers, config.loggers());
            report.append(String.format("\t%-30s %-6s %s%n", "#" + field.getField().getName(), config.level(), String.join((CharSequence)",", loggers)));
        });
        System.out.println(report);
    }

    @Override
    protected void beforeTest(EventContext context, AnnotatedField<RecordLogs, RecordedLogs> field, RecordedLogs value) {
    }

    @Override
    protected void afterTest(EventContext context, AnnotatedField<RecordLogs, RecordedLogs> field, RecordedLogs value) {
        if (field.getAnnotation().autoReset()) {
            value.clear();
        }
    }

    @Override
    public void stopped(EventContext context) {
        this.fields.forEach(field -> {
            RecordedLogs logs = (RecordedLogs)field.getCustomData(FIELD_RECORDER);
            if (logs != null) {
                logs.getRecorder().destroy();
            }
        });
        super.stopped(context);
    }
}

