/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext.mock;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestExtension;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedField;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedTestFieldSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.EventContext;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.mock.MockBean;
import ru.vyarus.dropwizard.guice.test.mock.MocksHook;
import ru.vyarus.dropwizard.guice.test.util.PrintUtils;
import ru.vyarus.dropwizard.guice.test.util.TestSetupUtils;

public class MockFieldsSupport
extends AnnotatedTestFieldSetup<MockBean, Object> {
    private static final String TEST_MOCK_FIELDS = "TEST_MOCK_FIELDS";
    private static final String FIELD_MOCK = "FIELD_MOCK";
    private final MocksHook hook = new MocksHook();

    public MockFieldsSupport() {
        super(MockBean.class, Object.class, TEST_MOCK_FIELDS);
    }

    @Override
    protected void fieldDetected(ExtensionContext context, AnnotatedField<MockBean, Object> field) {
    }

    @Override
    protected void registerHooks(TestExtension extension) {
        extension.hooks(this.hook);
    }

    @Override
    protected <K> void initializeField(AnnotatedField<MockBean, Object> field, Object userValue) {
        Class<Object> type = field.getType();
        if (userValue != null) {
            Preconditions.checkState((boolean)MockUtil.isMock((Object)userValue), (Object)(this.getDeclarationErrorPrefix(field) + "initialized instance is not a mockito mock object. Either provide correct mock or remove value and let extension create mock automatically."));
            this.hook.mock(type, userValue);
        } else {
            field.setCustomData(FIELD_MOCK, this.hook.mock(type));
        }
    }

    @Override
    protected void beforeValueInjection(EventContext context, AnnotatedField<MockBean, Object> field) {
    }

    @Override
    protected Object injectFieldValue(EventContext context, AnnotatedField<MockBean, Object> field) {
        return Preconditions.checkNotNull(field.getCustomData(FIELD_MOCK), (Object)"Mock not created");
    }

    @Override
    protected void report(EventContext context, List<AnnotatedField<MockBean, Object>> annotatedFields) {
        StringBuilder report = new StringBuilder("\nApplied mocks (@").append(MockBean.class.getSimpleName()).append(") on ").append(this.setupContextName).append(":\n\n");
        this.fields.forEach(field -> report.append(String.format("\t%-30s %-20s %s%n", "#" + field.getField().getName(), RenderUtils.renderClassLine(field.getType()), field.isCustomDataSet("manual_creation") ? "MANUAL" : "AUTO")));
        System.out.println(report);
    }

    @Override
    protected void beforeTest(EventContext context, AnnotatedField<MockBean, Object> field, Object value) {
    }

    @Override
    protected void afterTest(EventContext context, AnnotatedField<MockBean, Object> field, Object value) {
        if (field.getAnnotation().printSummary()) {
            String res = Mockito.mockingDetails((Object)value).printInvocations();
            System.out.println(PrintUtils.getPerformanceReportSeparator(context.getJunitContext()) + "@" + MockBean.class.getSimpleName() + " stats on [After each] for " + TestSetupUtils.getContextTestName(context.getJunitContext()) + ":\n\n" + Arrays.stream(res.split("\n")).map(s -> "\t" + s).collect(Collectors.joining("\n")));
        }
        if (field.getAnnotation().autoReset()) {
            Mockito.reset((Object[])new Object[]{value});
        }
    }
}

