/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext.rest;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import ru.vyarus.dropwizard.guice.GuiceBundle;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.GuiceyConfigurationInfo;
import ru.vyarus.dropwizard.guice.test.jupiter.TestGuiceyApp;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestExtension;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedField;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedTestFieldSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.EventContext;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.rest.StubRest;
import ru.vyarus.dropwizard.guice.test.rest.RestClient;
import ru.vyarus.dropwizard.guice.test.rest.RestStubsHook;
import ru.vyarus.dropwizard.guice.test.rest.StubRestConfig;
import ru.vyarus.dropwizard.guice.test.rest.support.ExtensionsSelector;

public class RestStubFieldsSupport
extends AnnotatedTestFieldSetup<StubRest, RestClient>
implements GuiceyConfigurationHook {
    private static final String TEST_RESOURCES_FIELD = "TEST_RESOURCES";
    private RestStubsHook restStubs;

    public RestStubFieldsSupport() {
        super(StubRest.class, RestClient.class, TEST_RESOURCES_FIELD);
    }

    @Override
    public void configure(GuiceBundle.Builder builder) throws Exception {
        builder.onGuiceyStartup((config, env, injector) -> Preconditions.checkState((!new EventContext(this.setupContext, false).isWebStarted() ? 1 : 0) != 0, (Object)("Resources stubbing is useless when application is fully started. Use it with @" + TestGuiceyApp.class.getSimpleName() + " where web services not started in order to start lightweight container with rest services.")));
    }

    @Override
    protected void registerHooks(TestExtension extension) {
        Preconditions.checkState((this.fields.size() == 1 ? 1 : 0) != 0, (Object)("Multiple @" + StubRest.class.getSimpleName() + " fields declared. To avoid confusion with the configuration, only one field is supported."));
        this.restStubs = new RestStubsHook(this.getConfig((StubRest)((AnnotatedField)this.fields.get(0)).getAnnotation()));
        extension.hooks(this.restStubs, this);
    }

    @Override
    protected void fieldDetected(ExtensionContext context, AnnotatedField<StubRest, RestClient> field) {
    }

    @Override
    protected <K> void initializeField(AnnotatedField<StubRest, RestClient> field, RestClient userValue) {
    }

    @Override
    protected void beforeValueInjection(EventContext context, AnnotatedField<StubRest, RestClient> field) {
    }

    @Override
    protected RestClient injectFieldValue(EventContext context, AnnotatedField<StubRest, RestClient> field) {
        return (RestClient)Preconditions.checkNotNull((Object)this.restStubs.getRestClient(), (Object)"Rest stub is required");
    }

    @Override
    protected void report(EventContext context, List<AnnotatedField<StubRest, RestClient>> annotatedFields) {
        StringBuilder report = new StringBuilder(500);
        report.append("REST stub (@").append(StubRest.class.getSimpleName()).append(") started on ").append(this.setupContextName).append(":\n").append("\n\tJersey test container factory: ").append(this.restStubs.getJerseyStub().getTestContainerFactory().getClass().getName()).append("\n\tDropwizard exception mappers: ").append(annotatedFields.get(0).getAnnotation().disableDropwizardExceptionMappers() ? "DISABLED" : "ENABLED").append('\n');
        ExtensionsSelector selector = new ExtensionsSelector(context.getBean(GuiceyConfigurationInfo.class));
        List<Class<?>> resources = selector.getResources();
        report.append("\n\t").append(resources.size()).append(" resources");
        int disabledResources = selector.getDisabledResourcesCount();
        if (disabledResources > 0) {
            report.append(" (disabled ").append(disabledResources).append(')');
        }
        report.append(":\n");
        resources.forEach(resource -> report.append(String.format("\t\t%s%n", RenderUtils.renderClassLine(resource))));
        List<Class<?>> extensions = selector.getExtensions();
        report.append("\n\t").append(extensions.size()).append(" jersey extensions");
        int disabledExtensions = selector.getDisabledExtensionsCount();
        if (disabledExtensions > 0) {
            report.append(" (disabled ").append(disabledExtensions).append(')');
        }
        report.append(":\n");
        extensions.forEach(resource -> report.append(String.format("\t\t%s%n", RenderUtils.renderClassLine(resource))));
        report.append("\n\tUse .printJerseyConfig() report to see ALL registered jersey extensions (including dropwizard)\n");
        System.out.println(report);
    }

    @Override
    protected void beforeTest(EventContext context, AnnotatedField<StubRest, RestClient> field, RestClient value) {
    }

    @Override
    protected void afterTest(EventContext context, AnnotatedField<StubRest, RestClient> field, RestClient value) {
        if (field.getAnnotation().autoReset()) {
            value.reset();
        }
    }

    private StubRestConfig getConfig(StubRest annotation) {
        StubRestConfig config = new StubRestConfig();
        Collections.addAll(config.getResources(), annotation.value());
        Collections.addAll(config.getDisableResources(), annotation.disableResources());
        Collections.addAll(config.getJerseyExtensions(), annotation.jerseyExtensions());
        config.setDisableAllJerseyExtensions(annotation.disableAllJerseyExtensions());
        config.setDisableDropwizardExceptionMappers(annotation.disableDropwizardExceptionMappers());
        Collections.addAll(config.getDisableJerseyExtensions(), annotation.disableJerseyExtensions());
        config.setLogRequests(annotation.logRequests());
        config.setContainer(annotation.container());
        return config;
    }
}

