/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext.spy;

import com.google.common.base.Preconditions;
import com.google.inject.Binding;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockito.Mockito;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.InstanceUtils;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestExtension;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedField;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedTestFieldSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.EventContext;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.mock.MockBean;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.spy.SpyBean;
import ru.vyarus.dropwizard.guice.test.spy.SpiesHook;
import ru.vyarus.dropwizard.guice.test.spy.SpyProxy;
import ru.vyarus.dropwizard.guice.test.util.PrintUtils;
import ru.vyarus.dropwizard.guice.test.util.TestSetupUtils;

public class SpyFieldsSupport
extends AnnotatedTestFieldSetup<SpyBean, Object> {
    private static final String TEST_SPY_FIELDS = "TEST_SPY_FIELDS";
    private static final String FIELD_SPY = "FIELD_SPY";
    private final SpiesHook hook = new SpiesHook();

    public SpyFieldsSupport() {
        super(SpyBean.class, Object.class, TEST_SPY_FIELDS);
    }

    @Override
    protected void fieldDetected(ExtensionContext context, AnnotatedField<SpyBean, Object> field) {
    }

    @Override
    protected void registerHooks(TestExtension extension) {
        extension.hooks(this.hook);
    }

    @Override
    protected <K> void initializeField(AnnotatedField<SpyBean, Object> field, Object userValue) {
        Class<? extends Consumer<?>>[] initializers;
        if (userValue != null) {
            throw new IllegalStateException(this.getDeclarationErrorPrefix(field) + "manual spy declaration is not supported. Use @" + MockBean.class.getSimpleName() + " instead to specify manual spy object.");
        }
        SpyProxy<Object> proxy = this.hook.spy(field.getType());
        for (Class<? extends Consumer<?>> initializer : initializers = field.getAnnotation().initializers()) {
            proxy.withInitializer(InstanceUtils.create(initializer));
        }
        field.setCustomData(FIELD_SPY, proxy);
    }

    @Override
    protected void beforeValueInjection(EventContext context, AnnotatedField<SpyBean, Object> field) {
        SpyProxy spy = (SpyProxy)Preconditions.checkNotNull((Object)((SpyProxy)field.getCustomData(FIELD_SPY)));
        Binding binding = context.getInjector().getBinding(spy.getType());
        Preconditions.checkState((!this.isInstanceBinding(binding) ? 1 : 0) != 0, (String)(this.getDeclarationErrorPrefix(field) + "target bean '%s' bound by instance and so can't be spied"), (Object)spy.getType().getSimpleName());
    }

    @Override
    protected Object injectFieldValue(EventContext context, AnnotatedField<SpyBean, Object> field) {
        SpyProxy aop = (SpyProxy)field.getCustomData(FIELD_SPY);
        return aop.getSpy();
    }

    @Override
    protected void report(EventContext context, List<AnnotatedField<SpyBean, Object>> annotatedFields) {
        StringBuilder report = new StringBuilder("\nApplied spies (@").append(SpyBean.class.getSimpleName()).append(") on ").append(this.setupContextName).append(":\n\n");
        this.fields.forEach(field -> report.append(String.format("\t%-30s %-20s%n", "#" + field.getField().getName(), RenderUtils.renderClassLine(field.getType()))));
        System.out.println(report);
    }

    @Override
    protected void beforeTest(EventContext context, AnnotatedField<SpyBean, Object> field, Object value) {
    }

    @Override
    protected void afterTest(EventContext context, AnnotatedField<SpyBean, Object> field, Object value) {
        if (field.getAnnotation().printSummary()) {
            String res = Mockito.mockingDetails((Object)value).printInvocations();
            System.out.println(PrintUtils.getPerformanceReportSeparator(context.getJunitContext()) + "@" + SpyBean.class.getSimpleName() + " stats on [After each] for " + TestSetupUtils.getContextTestName(context.getJunitContext()) + ":\n\n" + Arrays.stream(res.split("\n")).map(s -> "\t" + s).collect(Collectors.joining("\n")));
        }
        if (field.getAnnotation().autoReset()) {
            Mockito.reset((Object[])new Object[]{value});
        }
    }
}

