/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext.stub;

import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestExtension;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedField;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedTestFieldSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.env.listen.EventContext;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.stub.StubBean;
import ru.vyarus.dropwizard.guice.test.stub.StubLifecycle;
import ru.vyarus.dropwizard.guice.test.stub.StubsHook;

public class StubFieldsSupport
extends AnnotatedTestFieldSetup<StubBean, Object> {
    private static final String TEST_STUB_FIELDS = "TEST_STUB_FIELDS";
    private final StubsHook hook = new StubsHook();

    public StubFieldsSupport() {
        super(StubBean.class, Object.class, TEST_STUB_FIELDS);
    }

    @Override
    protected void fieldDetected(ExtensionContext context, AnnotatedField<StubBean, Object> field) {
        Class<Object> type;
        Class<Object> key = field.getAnnotation().value();
        if (!key.isAssignableFrom(type = field.getType())) {
            throw new IllegalStateException(this.getDeclarationErrorPrefix(field) + type.getSimpleName() + " is not assignable to " + key.getSimpleName());
        }
    }

    @Override
    protected void registerHooks(TestExtension extension) {
        extension.hooks(this.hook);
    }

    @Override
    protected <K> void initializeField(AnnotatedField<StubBean, Object> field, Object userValue) {
        Class<?> key = field.getAnnotation().value();
        if (userValue != null) {
            this.hook.stub(key, userValue);
        } else {
            this.hook.stub(key, field.getType());
        }
    }

    @Override
    protected void beforeValueInjection(EventContext context, AnnotatedField<StubBean, Object> field) {
    }

    @Override
    protected Object injectFieldValue(EventContext context, AnnotatedField<StubBean, Object> field) {
        return context.getBean(field.getAnnotation().value());
    }

    @Override
    protected void report(EventContext context, List<AnnotatedField<StubBean, Object>> fields) {
        StringBuilder report = new StringBuilder("\nApplied stubs (@").append(StubBean.class.getSimpleName()).append(") on ").append(this.setupContextName).append(":\n\n");
        fields.forEach(field -> report.append(String.format("\t%-40s %-10s %20s >> %-20s%n", field.getField().getDeclaringClass().getSimpleName() + "." + field.getField().getName(), field.isCustomDataSet("manual_creation") ? "MANUAL" : "GUICE", ((StubBean)field.getAnnotation()).value().getSimpleName(), field.getType().getSimpleName())));
        System.out.println(report);
    }

    @Override
    protected void beforeTest(EventContext context, AnnotatedField<StubBean, Object> field, Object value) {
        if (value instanceof StubLifecycle) {
            ((StubLifecycle)value).before();
        }
    }

    @Override
    protected void afterTest(EventContext context, AnnotatedField<StubBean, Object> field, Object value) {
        if (value instanceof StubLifecycle) {
            ((StubLifecycle)value).after();
        }
    }
}

